<?php

/**
 * Created by FsFlex.
 * User: VH
 * Date: 5/28/2018
 * Time: 4:45 PM
 */
namespace ef4;

use Stripe\Error\RateLimit;
use Stripe\Error\Card;
use Stripe\Error\InvalidRequest;
use Stripe\Error\Authentication;
use Stripe\Error\ApiConnection;
use Stripe\Error\Base;
use Stripe\Product;
use Stripe\Plan;
use Stripe\Stripe;
use Stripe\Charge;
use Stripe\Token;

class StripeApi extends EF4PaymentApi
{
    public function create_purchased_payment(array $purchased_items, array $payment_data)
    {
        parent::create_purchased_payment($purchased_items, $payment_data); // TODO: Change the autogenerated stub
        $payment_data = wp_parse_args($payment_data, [
            'card_token'       => '',
            'source' => '',
            'description'    => '',
            'payment_id'     => '',
        ]);
        if(!$this->is_valid_token($payment_data['card_token']))
        {
            return [
                'status' => 'fail',
                'key'    => 'payment_stripe_invalid_card_info_3',
                'data'   => 'stripe'
            ];
        }
        $total_amount = 0;
        foreach ($purchased_items as $purchased_item) {
            $purchased_item = wp_parse_args($purchased_item, [
                'name'     => '',
                'currency' => '',
                'quantity' => '',
                'price'    => '',
            ]);
            $price = ef4()->parse_float_val($purchased_item['price']);
            $quantity = intval($purchased_item['quantity']);
            $total_amount += $price * $quantity;
        }
        $charge = $this->do_api_request('charge', [
            "amount"      => $total_amount,
            "currency"    => $payment_data['currency'],
            "source"      => $payment_data['card_token'],
            'description' => $payment_data['description'],
        ],$payment_data['source']);
        if ($charge instanceof Charge) {
            $json_data = $charge->jsonSerialize();
            $charge_data =
                [time() => $json_data];
            $payment_id = $payment_data['payment_id'];
            update_post_meta($payment_id, 'stripe_charge_data', $charge_data);
            update_post_meta($payment_id, 'stripe_charge_id', $json_data['id']);
            wp_publish_post($payment_id);
            return 'success';
        }
        return [
            'status' => 'fail',
            'key'    => 'payment_stripe_charge_fail',
        ];
    }

    function is_valid_token($token)
    {
        if (!$token instanceof Token)
            return false;
        return true;
    }

    function get_card_token($card_info)
    {
        if(empty($card_info['source']))
            return false;
        $source = $card_info['source'];
        $card_info_use_fields = ['number','exp_month','exp_year','cvc'];
        $card_data = [];
        foreach ($card_info_use_fields as $field)
        {
            if(empty($card_info[$field]))
                return false;
            $card_data[$field] = $card_info[$field];
        }
        return $this->do_api_request('get_card_token',$card_data,$source);
    }

    function check_charge($payment_id, $charge_id)
    {
        if (get_post_type($payment_id) !== 'ef4_payment') {
            Log::add_err('protect_invalid_function_params', ['function' => 'check_payment_charge', 'payment_id' => $payment_id]);
            return false;
        }
        Log::$post_save_log = $payment_id;
        $payment_charge_id = get_post_meta($payment_id, 'stripe_charge_id', true);
        if ($payment_charge_id !== $charge_id) {
            Log::add_err('protect_invalid_function_params', ['function' => 'check_payment_charge', 'charge_id' => $charge_id]);
            return false;
        }
        $source = get_post_meta($payment_id,'items_source',true);
        $charge = $this->do_api_request('retrieve_charge', $charge_id,$source);
        if ($charge instanceof Charge) {
            $charge_data = get_post_meta($payment_id, 'stripe_charge_data', true);
            $charge_data[time()] = $charge->jsonSerialize();
            update_post_meta($payment_id, 'stripe_charge_data', $charge_data);
            return true;
        }
    }

    function create_product($data)
    {
        return;
        $data = wp_parse_args($data, [
            'donation_id' => '',
            "name"        => '',
            "type"        => '',
            "description" => '',
        ]);
        $product_data = [
            "name" => zodonations()->get_donation_name($data['donation_id']),
            "type" => "service",
            //"description" => $this->get_description($data),
            //'url'=> zodonations()->get_donation_url($data['donation_id'])
        ];
        //create product;
        $product_id = 'prod_Cwbvg5jKDVUpTz';
        if (empty($product_id)) {
            $product = $this->do_api_request('create_product', $product_data);
            $product_id = $product->id;
        }
        //create plan
        $explan = $this->do_api_request('retrieve_plan', 'plan_Cwql5PwH4ujk7D');
        $n_explan = $this->do_api_request('retrieve_plan', 'test-1');
        $plan = $this->do_api_request('create_plan', ['product'  => $product_id,
                                                      'nickname' => 'Sample Plan - 50 USD - monthly - 12 month',
                                                      'interval' => 'month',
                                                      'currency' => 'usd',
                                                      'amount'   => 5000,]);
    }

    function get_plan($payment_data)
    {
        $plan_id = $this->create_plan_id($payment_data);
        $product_id = 'prod_Cwbvg5jKDVUpTz';
        $plan = $this->do_api_request('try_retrieve_plan', $plan_id);
        if (!$plan)
            $plan = $this->do_api_request('create_plan', [
                'product'  => $product_id,
                'nickname' => 'Sample Plan - 50 USD - monthly - 12 month',
                'interval' => $payment_data['repeat'],
                'currency' => $payment_data['currency'],
                'id'       => $plan_id,
                'amount'   => $payment_data['amount'],
            ]);
    }

    function create_plan_id($payment_data)
    {
        $data = wp_parse_args($payment_data, [
            'amount'   => '',
            'currency' => '',
            'repeat'   => "",
        ]);
        return "donation-{$data['repeat']}-{$data['amount']}-{$data['currency']}";
    }

    function maybe_fix_amount($amount, $currency)
    {
        $amount = ef4()->parse_float_val($amount);
        $zero_decimal_currencies = [
            'MGA', 'BIF', 'CLP', 'PYG', 'DJF', 'RWF', 'GNF', 'UGX', 'JPY',
            'VND', 'VUV', 'XAF', 'KMF', 'KRW', 'XOF', 'XPF'
        ];
        if (in_array(strtoupper($currency), $zero_decimal_currencies))
            return intval($amount);
        return intval($amount * 100);
    }

    function do_api_request($method, $params = '', $source)
    {
        $required_secret_key = [
            'charge', 'retrieve_charge',
            'create_product', 'retrieve_product',
            'create_plan', 'retrieve_plan', 'is_plan_exist'
        ];
        $data_key = apply_filters('ef4_stripe_api_key_data', [
            'key_secret'      => '',
            'key_publishable' => '',
//            'type'          => '',
        ], $source);
        if (in_array($method, $required_secret_key))
            Stripe::setApiKey($data_key['key_secret']);
        else
            Stripe::setApiKey($data_key['key_publishable']);
        $result = null;
        try {
            switch ($method) {
                case 'try_retrieve_plan':
                    try {
                        $result = Plan::retrieve($params);
                    } catch (\Exception $e) {
                        $result = false;
                    }
                    if (!$result instanceof Plan)
                        $result = false;
                    break;
                case 'retrieve_plan':
                    $result = Plan::retrieve($params);
                    break;
                case 'create_plan':
                    $result = Plan::create($params);
                    break;
                case 'retrieve_product':
                    $result = Product::retrieve($params);
                    break;
                case 'create_product':
                    $result = Product::create($params);
                    break;
                case 'charge':
                    $args = wp_parse_args($params, [
                        "amount"      => '',
                        "currency"    => 'usd',
                        "source"      => '',
                        'description' => ''
                    ]);
                    $currency = strtolower($args['currency']);
                    $args['amount'] = $this->maybe_fix_amount($args['amount'], $currency);
                    $result = @Charge::create($args);
                    break;
                case 'retrieve_charge':
                    $result = @Charge::retrieve($params);
                    break;
                case 'get_card_token':
                    $card_info = wp_parse_args($params, [
                        'number'    => '',
                        'exp_month' => '',
                        'exp_year'  => '',
                        'cvc'       => ''
                    ]);
                    $result = @Token::create([
                            "card" => $card_info
                        ]
                    );
                    break;
            }
            // Use Stripe's library to make requests...
        } catch (Card $e) {
            // Since it's a decline, \Stripe\Error\Card will be caught
            $body = $e->getJsonBody();
            $err = $body['error'];
            $err_message = 'Status is:' . $e->getHttpStatus() . "\n";
            $err_message .= 'Type is:' . $err['type'] . "\n";
            $err_message .= 'Code is:' . $err['code'] . "\n";
            // param is '' in this case
            $err_message .= 'Param is:' . $err['param'] . "\n";
            $err_message .= 'Message is:' . $err['message'] . "\n";
            Log::add_err('stripe_card', $err_message);
        } catch (RateLimit $e) {
            Log::add_err('stripe_rate_limit');
            // Too many requests made to the API too quickly
        } catch (InvalidRequest $e) {
            Log::add_err('stripe_invalid_request');
            // Invalid parameters were supplied to Stripe's API
        } catch (Authentication $e) {
            Log::add_err('stripe_authentication');
            // Authentication with Stripe's API failed
            // (maybe you changed API keys recently)
        } catch (ApiConnection $e) {
            Log::add_err('stripe_api_connection');
            // Network communication with Stripe failed
        } catch (Base $e) {
            Log::add_err('stripe_base');
            // Display a very generic error to the user, and maybe send
            // yourself an email
        } catch (\Exception $e) {
            Log::add_err('stripe_unknown');
            // Something else happened, completely unrelated to Stripe
        }
        return $result;
    }
}

