jQuery(document).ready(function($) {
	"use strict";

	/* window */
	var window_width, window_height, scroll_top;

	/* admin bar */
	var adminbar = $('#wpadminbar');
	var adminbar_height = 0;
   
	/* header menu */
	var header = $('#cshero-header');
	var header_top = 0;
    
	/* scroll status */
	var scroll_status = '';

	/**
	 * window load event.
	 * 
	 * Bind an event handler to the "load" JavaScript event.
	 * @author Fox
	 */
	$(window).on('load', function() {
	   
        if ( $('.wow').length ) {
          initWow(); 
        };
        
		/** current scroll */
		scroll_top = $(window).scrollTop();

		/** current window width */
		window_width = $(window).width();

		/** current window height */
		window_height = $(window).height();

		/* get admin bar height */
		adminbar_height = adminbar.length > 0 ? adminbar.outerHeight(true) : 0 ;

		/* get top header menu */
		header_top = header.length > 0 ? header.offset().top - adminbar_height : 0 ;
         
		cms_lightbox_popup();
        
        if(CMSOptions.menu_sticky == '1')  
            cms_stiky_menu();
        
        /* auto resize video width */
        cms_auto_post_video_width();
          
        $('.blog-columns').isotope({
            itemSelector: '.blog-columns > div',
        });
        if($(window).width() >= 992){
            setTimeout(function(){ custom_vc_fullright(); }, 200);
            setTimeout(function(){ custom_quote_form_visible(); }, 1000);
        }
         
	});
    function custom_vc_fullright(){
        $('.wpb_column.right-full').css('position','absolute');
    }
    function custom_quote_form_visible(){
        $('.quote-form-overlap').css({'opacity':'1','visibility':'visible'});
    }
	/**
	 * reload event.
	 * 
	 * Bind an event handler to the "navigate".
	 */
	window.onbeforeunload = function(){
	}
	
	/**
	 * resize event.
	 * 
	 * Bind an event handler to the "resize" JavaScript event, or trigger that event on an element.
	 * @author Fox
	 */
	$(window).on('resize', function(event, ui) {
		/** current window width */
		window_width = $(event.target).width();

		/** current window height */
		window_height = $(window).height();

		/** current scroll */
		scroll_top = $(window).scrollTop();
        
        /* auto resize video width */
        cms_auto_post_video_width();
         
	});
	
	/**
	 * scroll event.
	 * 
	 * Bind an event handler to the "scroll" JavaScript event, or trigger that event on an element.
	 * @author Fox
	 */
	$(window).on('scroll', function() {
		/** current scroll */
		scroll_top = $(window).scrollTop();
        
        cms_back_to_top();
	});
    
    $(document).ajaxComplete(function(){  
        cms_auto_post_video_width();
    });
    
	$(".tnp-email").attr("placeholder", "Enter Your Email Address.....");
    
    $('.cms-history .collapse.in').parents('.panel').addClass('active');
    $('.cms-history .panel-heading a').on('click', function () { 
        $('.cms-history .panel').removeClass('active');
        $(this).parents('.panel').addClass('active');
    });
      
    //search modal
	$(".search_modal_button").on('click', function(e){  
		e.preventDefault();
		$('#search_modal').modal('show').find('input').first().focus();
        $("body.modal-open").removeAttr("style");
	});
    
    $('body').click(function (e) {
        var target = $(e.target);
        if ( !target.hasClass('link-popup-share') && !target.hasClass('fa-share-alt')) {
            $('.entry-share').removeClass('open');
        }
    });
     
    $('.link-popup-share').on('click', function(e){
    	e.preventDefault();
    	var check = $(this).parent().find('.entry-share');
    	if(!check.hasClass('open')){
			check.addClass('open');
		} else {
			check.removeClass('open');
		}
	});
  
    //testimonials owl carousel
	$('.testimonials-owl-dots').each(function() {
		var $owl1 = $(this);
		var $owl2 = $owl1.next('.testimonials-owl-content');

		$owl1.on('click', '.owl-item', function(e) {
		  var carousel = $owl1.data('owl.carousel');
		  e.preventDefault();
		  carousel.to(carousel.relative($(this).index()));
		})
		.on('change.owl.carousel', function(event) {
			if (event.namespace && event.property.name === 'position') {
				var target = event.relatedTarget.relative(event.property.value, true);
				$owl2.owlCarousel('to', target, 300, true);
			}
		});
	});
       
    /**
     * Edit the count on the categories widget
     * @author Chinh Duong Manh
     * @since 1.0.0
     * @param element parent
    */

    $.fn.extend({
        cmsReplaceCount: function(is_woo){
            this.each(function(){
                if (is_woo == true) {
                    $(this).find('span.count').each(function(){
                        var count =  $(this).text();
                        var appendTo = $(this).parent().find('> a');
                        $(this).appendTo(appendTo);
                    })  
                } else {
                    $(this).find(' > ul > li').each(function() {
                        var cms_li = $(this);
                        cms_li.removeClass('recentcomments');
                        var small = $(this).html().replace('</a>&nbsp;(','&nbsp;<span class="count">(').replace(')',')</span></a>').replace('</a> (','<span class="count">&nbsp;(');
                        cms_li.html(small);
                        $(this).find(' .children li').each(function() {
                            var sm = $(this).html().replace('</a>&nbsp;(','&nbsp;<span class="count">(').replace(')',')</span></a>').replace('</a> (','<span class="count">&nbsp;(');
                            $(this).html(sm);
                            $(this).find(' .children li').each(function() {
                             var s = $(this).html().replace('</a>&nbsp;(','&nbsp;<span class="count">(').replace(')',')</span></a>').replace('</a> (','<span class="count">&nbsp;(');
                             $(this).html(s);
                            })
                        })
                    });
                }
            })
        }
    });
    
    $('.widget_archive, .widget_categories, .product-categories').cmsReplaceCount(false);    
        
    /* Wow animation */
    function initWow(){
        var wow = new WOW( { mobile: false, } );
        wow.init();
    };
    
    
    /**
	 * Auto width video iframe
	 * 
	 * Youtube Vimeo.
	 * @author Fox
	 */
	function cms_auto_post_video_width() {  
		$('.entry-video iframe').each(function(){
			var v_width =$('.entry-video').width();
			var v_height = v_width / (16/9);
            $(this).attr('width',v_width);
			$(this).attr('height',v_height + 35);
		})
        $('.entry-video iframe').each(function(){
            $(this).attr('width','100%');
		});
		$('.format-video iframe').attr('width','100%');
	} 
	/**
	 * Stiky menu
	 *
	 * Show or hide sticky menu.
	 * @author Fox
	 * @since 1.0.0
	 */
	 function cms_stiky_menu() {
	   
    	if (header.length) {
    		var headerHeight = header.outerHeight();
    		header.wrap('<div class="page_header_wrapper"></div>').parent().css({height: headerHeight}); //wrap header for smooth stick and unstick
    		 
    
    		//get offset
    		var headerOffset = 0;
    		//check for sticked template headers
                headerOffset = (header.offset().top);
    		//for boxed layout - show or hide main menu elements if width has been changed on affix
    		$(header).on('affixed-top.bs.affix affixed.bs.affix affixed-bottom.bs.affix', function ( e ) {
    			if( header.hasClass('affix-top') ) {
    				header.parent().removeClass('affix-wrapper affix-bottom-wrapper').addClass('affix-top-wrapper');
    			} else if ( header.hasClass('affix') ) {
    				header.parent().removeClass('affix-top-wrapper affix-bottom-wrapper').addClass('affix-wrapper');
    			} else if ( header.hasClass('affix-bottom') ) {
    				header.parent().removeClass('affix-wrapper affix-top-wrapper').addClass('affix-bottom-wrapper');
    			} else {
    				header.parent().removeClass('affix-wrapper affix-top-wrapper affix-bottom-wrapper');
    			}
    		 
    		});
    
    		//if header has different height on afixed and affixed-top positions - correcting wrapper height
    		$(header).on('affixed-top.bs.affix', function () {
    		   if( !$( window ).scrollTop() ) return false;
    			header.parent().css({height: header.outerHeight()});
    		});
             
    		$(header).affix({
    			offset: {
    				top: headerOffset,
    				bottom: 0
    			}
    		});
    	}
        
	} 
      
	/**
	 * Mobile menu
	 * 
	 * Show or hide mobile menu.
	 * @author Fox
	 * @since 1.0.0
	 */
	
	$('body').on('click', '#cshero-menu-mobile', function(){
		var navigation = $(this).parent().find('#cshero-header-navigation');
		if(!navigation.hasClass('collapse')){
			navigation.addClass('collapse');
		} else {
			navigation.removeClass('collapse');
		}
	});

	/**
	 * Back to top
	 */
	$('body').on('click', '.ef3-back-to-top', function () {
		$('body, html').animate({scrollTop:0}, '1000');
	})
    
      /* Show or hide buttom  */
	function cms_back_to_top(){
		/* back to top */
        if (scroll_top < window_height) {
        	$('.ef3-back-to-top').addClass('off').removeClass('on');
        } else {
        	$('.ef3-back-to-top').removeClass('off').addClass('on');
        }
	}
    
     
    
	/**
	 * One page
	 *
	 * @author Fox
	 */
	if(typeof(one_page_options) != "undefined"){
		one_page_options.speed = parseInt(one_page_options.speed);
		$('#site-navigation').singlePageNav(one_page_options);
	}
    
    /**
	 * LightBox
	 * 
	 * @author Knight
	 * @since 1.0.0
	 */
	function cms_lightbox_popup() {   
		$('.magic-popup,.cms-product-gallery .zoom').magnificPopup({
			// delegate: 'a',
			type: 'image',
			mainClass: 'mfp-3d-unfold',
			removalDelay: 500,  
			callbacks: {
				beforeOpen: function() {
				this.st.image.markup = this.st.image.markup.replace('mfp-figure', 'mfp-figure mfp-with-anim');
				}
			},
			closeOnContentClick: true,
			midClick: true  
		});
        
        
        $('.cms-video-popup').magnificPopup({
			//disableOn: 700,
			type: 'iframe',
			mainClass: 'mfp-fade',
			removalDelay: 160,
			preloader: false,
			fixedContentPos: false
		});
		
       
        $('.cms-map-popup').magnificPopup({
			type: 'iframe',
			mainClass: 'mfp-fade',
			removalDelay: 160,
			preloader: false,

			fixedContentPos: false
		});
        
		/* gallery */
		$('.gallery-popup-wrap').each(function(i, el) {
			$(el).magnificPopup({
				delegate: '.magic-popups',
				type: 'image',
				tLoading: 'Loading image #%curr%...',
				mainClass: 'mfp-3d-unfold',
				removalDelay: 500, 
				callbacks: {
					beforeOpen: function() {
						this.st.image.markup = this.st.image.markup.replace('mfp-figure', 'mfp-figure mfp-with-anim');
					}
				},
				gallery: {
					enabled: true,
					navigateByImgClick: true,
					preload: [0,1] 
				},
				image: {
					tError: '<a href="%url%">The image #%curr%</a> could not be loaded.',
				}
			});
		});
        $('.cms-gallerys').magnificPopup({
			delegate: '.magic-popups',
			type: 'image',
			tLoading: 'Loading image #%curr%...',
			mainClass: 'mfp-3d-unfold',
			removalDelay: 500,  
			callbacks: {
				beforeOpen: function() {
					this.st.image.markup = this.st.image.markup.replace('mfp-figure', 'mfp-figure mfp-with-anim');
				}
			},
			gallery: {
				enabled: true,
				navigateByImgClick: true,
				preload: [0,1]  
			},
			image: {
				tError: '<a href="%url%">The image #%curr%</a> could not be loaded.',
			}
		}); 
	}
      
});