<?php

/**
 * Auto create .css file from Theme Options
 * @author Fox
 * @version 1.0.0
 */
class CMSSuperHeroes_StaticCss
{

    public $scss;
    
    function __construct()
    {
        if(!class_exists('scssc'))
            return;

        /* scss */
        $this->scss = new scssc();
        
        /* set paths scss */
        $this->scss->setImportPaths(get_template_directory() . '/assets/scss/');
             
        /* generate css over time */
		add_action('wp', array($this, 'generate_over_time'));
        
        /* save option generate css */
       	add_action("redux/options/opt_theme_options/saved", array($this,'generate_file'));
    }
	
    public function generate_over_time(){ 
    	
    	global $opt_theme_options;

    	if (!empty($opt_theme_options) && $opt_theme_options['dev_mode']){ 
    	    $this->generate_file();
    	}
    }
    /**
     * generate css file.
     *
     * @since 1.0.0
     */
    public function generate_file()
    {
        global $opt_theme_options, $wp_filesystem;
        
        if (empty($wp_filesystem) || !isset($opt_theme_options)){  
            return;
        }
            
        $options_scss = get_template_directory() . '/assets/scss/options.scss';
        $options_render_scss  = get_template_directory() . '/assets/scss/options.render.scss';

        /* delete files options.scss */
        $wp_filesystem->delete($options_scss);
        $wp_filesystem->delete($options_render_scss);

        /* write options to scss file */
        $wp_filesystem->put_contents($options_scss, $this->css_render(), FS_CHMOD_FILE); // Save it
        $wp_filesystem->put_contents($options_render_scss, $this->css_option_render(), FS_CHMOD_FILE); // Save it
        

        /* minimize CSS styles */
        if (!$opt_theme_options['dev_mode'])
            $this->scss->setFormatter('scss_formatter_compressed');

        /* compile scss to css */
        $css = $this->scss_render();
         
        $file = "static.css";

        $file = get_template_directory() . '/assets/css/' . $file;
        
        /* delete files static.css */
        $wp_filesystem->delete($file);

        /* write static.css file */
        $wp_filesystem->put_contents($file, $css, FS_CHMOD_FILE); // Save it
         
    }
    
    /**
     * scss compile
     * 
     * @since 1.0.0
     * @return string
     */
    public function scss_render(){ 
        /* compile scss to css */
        return $this->scss->compile('@import "master.scss"');
    }
    
    public function primary_HexToRGB($hex,$opacity = 1) {
        $hex = str_replace("#",null, $hex);
        $color = array();
        if(strlen($hex) == 3) {
            $color['r'] = hexdec(substr($hex,0,1).substr($hex,0,1));
            $color['g'] = hexdec(substr($hex,1,1).substr($hex,1,1));
            $color['b'] = hexdec(substr($hex,2,1).substr($hex,2,1));
            $color['a'] = $opacity;
        }
        else if(strlen($hex) == 6) {
            $color['r'] = hexdec(substr($hex, 0, 2));
            $color['g'] = hexdec(substr($hex, 2, 2));
            $color['b'] = hexdec(substr($hex, 4, 2));
            $color['a'] = $opacity;
        }
        $color = "rgba(".implode(', ', $color).")";
        return $color;
    }
    /**
     * main css
     *
     * @since 1.0.0
     * @return string
     */
    public function css_render()
    {
        global $opt_theme_options,$opt_meta_options;
        
        ob_start();
        
        /* second_color */
        
        if(isset($opt_theme_options['general_layout']) && $opt_theme_options['general_layout']){ 
            echo '$boxed_width:'.esc_attr($opt_theme_options['body_width']['width']).';';
        }else{
            echo '$boxed_width:1500px;';
        }
        
        if(!empty($opt_theme_options['font_body']['color']))
            echo '$body_color:'.esc_attr($opt_theme_options['font_body']['color']).';';
        
        if(!empty($opt_theme_options['primary_color']))
            echo '$primary_color:'.esc_attr($opt_theme_options['primary_color']).';';
            echo '$primary_color_hex:'.$this->primary_HexToRGB($opt_theme_options['primary_color'],0.6).';';
            echo '$primary_color_hex_09:'.$this->primary_HexToRGB($opt_theme_options['primary_color'],0.9).';';
         
        if(!empty($opt_theme_options['link_color']['regular']))
            echo '$link_color_regular:'.esc_attr($opt_theme_options['link_color']['regular']).';';
            
        if(!empty($opt_theme_options['link_color']['hover']))
            echo '$link_color_hover:'.esc_attr($opt_theme_options['link_color']['hover']).';';
        
        if(!empty($opt_theme_options['button_default_color']['regular']))
            echo '$button_default_color_regular:'.esc_attr($opt_theme_options['button_default_color']['regular']).';';
        else 
            echo '$button_default_color_regular: #050505;';
            
        if(!empty($opt_theme_options['button_default_color']['hover']))
            echo '$button_default_color_hover:'.esc_attr($opt_theme_options['button_default_color']['hover']).';';
        else 
            echo '$button_default_color_hover: #fdb415;';
            
        if(!empty($opt_theme_options['button_primary_color']['regular']))
            echo '$button_primary_color_regular:'.esc_attr($opt_theme_options['button_primary_color']['regular']).';';
        else 
            echo '$button_primary_color_regular: #fdb415;';
            
        if(!empty($opt_theme_options['button_primary_color']['hover']))
            echo '$button_primary_color_hover:'.esc_attr($opt_theme_options['button_primary_color']['hover']).';';
        else 
            echo '$button_primary_color_hover: #050505;';
            
        
        echo '$button_color_inverse: #242424;';
         
        if(!empty($opt_theme_options['logo_max_height']['height']) && trim($opt_theme_options['logo_max_height']['height']) != 'px')
            echo '$logo_max_height:'.esc_attr($opt_theme_options['logo_max_height']['height']).';';
        else
            echo '$logo_max_height:100%;'; 
         
        if(!empty($opt_theme_options['sticky_logo_max_height']['height']) && trim($opt_theme_options['sticky_logo_max_height']['height']) != 'px')
            echo '$sticky_logo_max_height:'.esc_attr($opt_theme_options['sticky_logo_max_height']['height']).';';
        else
            echo '$sticky_logo_max_height:100%;';   
                 
        return ob_get_clean();
    }
    public function css_option_render(){
        global $opt_theme_options;
        
            ob_start();
            if(isset($opt_theme_options['general_layout']) && $opt_theme_options['general_layout'] == '1'){
                echo '@media screen and (min-width: 1200px){';
                echo '.affix{width: '.$opt_theme_options['body_width']['width'].';}';
                echo '}';
                echo '@media (min-width: 1200px){
                    .site-header .container-fullwidth {
                        padding-right: 0;
                        padding-left: 0;
                    } }';
                echo '@media (min-width: 1600px){
                    .site-header .container-fullwidth {
                        padding-right: 0;
                        padding-left: 0;
                    } }';
            }
             
            if(isset($opt_theme_options['header_padding']['padding-top']) && $opt_theme_options['header_padding']['padding-top'] != ''){
                echo '@media screen and (min-width: 1200px){
                    .cshero-main-header:not(.header-fixed) .main-navigation ul.nav-menu > li > a{padding-top:'.$opt_theme_options['header_padding']['padding-top'].';}
                    .header-layout4 .header-search-cart a{padding-top:'.$opt_theme_options['header_padding']['padding-top'].';}
                }';
            }
            if(isset($opt_theme_options['header_padding']['padding-bottom']) && $opt_theme_options['header_padding']['padding-bottom'] != ''){
                echo '@media screen and (min-width: 1200px){
                    .cshero-main-header:not(.header-fixed) .main-navigation ul.nav-menu > li > a{padding-bottom:'.$opt_theme_options['header_padding']['padding-bottom'].';}
                    .header-layout4 .header-search-cart a{padding-bottom:'.$opt_theme_options['header_padding']['padding-bottom'].';}
                }';
            }
            if(isset($opt_theme_options['header_margin_bottom']['margin-bottom']) && $opt_theme_options['header_margin_bottom']['margin-bottom'] != ''){
                echo '@media screen and (min-width: 1200px){
                    .header-layout2 .cshero-main-header:not(.affix) .container{margin-bottom:'.$opt_theme_options['header_margin_bottom']['margin-bottom'].';}
                }';
            }
             
        return ob_get_clean();
    }
}

new CMSSuperHeroes_StaticCss();