<?php
vc_map(array(
    "name" => 'CMS Button',
    "base" => "cms_button",
    "icon" => "cs_icon_for_vc",
    "category" => esc_html__('CmsSuperheroes Shortcodes', 'buildana'),
    "description" => esc_html__('Show social from theme option', 'buildana'),
    "params" => array(
        array(
        	"type" => "textfield",
            "heading" => esc_html__("Title",'buildana'),
            "param_name" => "title",
            "value" => "",
            "admin_label" => true,
            "description" => esc_html__("Title",'buildana'),
        ),
        array(
        	'type' => 'vc_link',
            'heading' => esc_html__( 'URL (Link)', 'buildana' ),
            'param_name' => 'link',
            'description' => esc_html__( 'Add link to button.', 'buildana' ),
        ),
        array(
        	"type" => "dropdown",
        	"heading" => esc_html__("Type",'buildana'),
        	"param_name" => "btn_type",
        	"value" => array(
                'Default' => 'btn-default',
                'Primary' => 'btn-primary',
                'Inverse' => 'btn-inverse',
            ),
            "std" => 'btn-default',
        ),
        array(
        	"type" => "dropdown",
        	"heading" => esc_html__("Size",'buildana'),
        	"param_name" => "size",
        	"value" => array(
                'Large' => 'btn-lg',
                'Medium' => 'btn-md',
                'Small' => 'btn-sm',
                'Small padding' => 'btn-sm-padding',
            ),
            "std" => 'btn-md',
            "description" => esc_html__( 'Select button size.', 'buildana' ),
        ),
        
        array(
        	"type" => "dropdown",
        	"heading" => esc_html__("Alignment",'buildana'),
        	"param_name" => "align",
        	"value" => array(
                'inline' => 'inline',
                'left' => 'left',
                'right' => 'right',
                'center' => 'center',
            ),
            "std" => 'inline',
        ),
        array(
            'type' => 'checkbox',
            'heading' => esc_html__("Set full width button?", 'buildana'),
            'param_name' => 'button_block',
            'value' => array(
                'Yes' => true
            ),
            'dependency' => array(
                'element' => 'align',
                'value' => array(
                    'left',
                    'right',
                    'center',
                ),
            ),
            'std' => false,
        ),
        array(
            'type' => 'checkbox',
            'heading' => esc_html__("Add icon", 'buildana'),
            'param_name' => 'add_icon',
            'value' => array(
                'Yes' => true
            ),
            'std' => false,
        ),
        array(
        	"type" => "dropdown",
        	"heading" => esc_html__("Icon Alignment",'buildana'),
        	"param_name" => "i_align",
        	"value" => array(
                'Left' => 'left',
                'Right' => 'right',
            ),
            'dependency' => array(
                'element' => 'add_icon',
                'value' => array(
                    '1',
                ),
            ),
            "std" => 'left',
        ),
        
        array(
            'type' => 'dropdown',
        	'heading' => esc_html__( 'Icon library', 'buildana' ),
        	'value' => array(
        		esc_html__( 'Font Awesome', 'buildana' ) => 'fontawesome',
                esc_html__( 'Glyphicons Icon', 'buildana' ) => 'glyphicons',
                esc_html__( 'RT Icon 2', 'buildana' ) => 'rticon2',
                esc_html__( 'P7 Stroke', 'buildana' ) => 'pe7stroke',
        	),
        	'param_name' => 'icon_type',
        	'description' => esc_html__( 'Select icon library.', 'buildana' ),
            'dependency' => array(
                'element' => 'add_icon',
                'value' => array(
                    '1',
                ),
            ),
        ),
        array(
			'type' => 'iconpicker',
			'heading' => esc_html__( 'Icon Item', 'buildana' ),
			'param_name' => 'icon_fontawesome',
            'value' => '',
			'settings' => array(
				'emptyIcon' => true,  
				'type' => 'fontawesome',
				'iconsPerPage' => 200,  
			),
			'dependency' => array(
				'element' => 'icon_type',
				'value' => 'fontawesome',
			),
			'description' => esc_html__( 'Select icon from library.', 'buildana' ),
		 
		),
        array(
			'type' => 'iconpicker',
			'heading' => esc_html__( 'Icon Item', 'buildana' ),
			'param_name' => 'icon_glyphicons',
            'value' => '',
			'settings' => array(
				'emptyIcon' => true, 
				'type' => 'glyphicons',
				'iconsPerPage' => 200,  
			),
			'dependency' => array(
				'element' => 'icon_type',
				'value' => 'glyphicons',
			),
			'description' => esc_html__( 'Select icon from library.', 'buildana' ),
		),
        array(
			'type' => 'iconpicker',
			'heading' => esc_html__( 'Icon Item', 'buildana' ),
			'param_name' => 'icon_rticon2',
            'value' => '',
			'settings' => array(
				'emptyIcon' => true, 
				'type' => 'rticon2',
				'iconsPerPage' => 200,  
			),
			'dependency' => array(
				'element' => 'icon_type',
				'value' => 'rticon2',
			),
			'description' => esc_html__( 'Select icon from library.', 'buildana' ),	 
		),
        array(
			'type' => 'iconpicker',
			'heading' => esc_html__( 'Icon Item', 'buildana' ),
			'param_name' => 'icon_pe7stroke',
            'value' => '',
			'settings' => array(
				'emptyIcon' => true, 
				'type' => 'pe7stroke',
				'iconsPerPage' => 200,  
			),
			'dependency' => array(
				'element' => 'icon_type',
				'value' => 'pe7stroke',
			),
			'description' => esc_html__( 'Select icon from library.', 'buildana' ),	 
		),
         
        array(
        	"type" => "textfield",
            "heading" => esc_html__("Class",'buildana'),
            "param_name" => "el_class",
            "value" => "",
            "description" => esc_html__("Class",'buildana'),
        ), 
        array(
        	'type' => 'css_editor',
            'heading' => esc_html__( 'CSS box', 'buildana' ),
            'param_name' => 'css',
            'group' => esc_html__( 'Design Options', 'buildana' ),
        )
    )
));
class WPBakeryShortCode_cms_button extends CmsShortCode
{
    protected function content($atts, $content = null)
    {
        return parent::content($atts, $content);
    }
}