<?php
vc_map(array(
    'name' => 'CMS Client',
    'base' => 'cms_client',
    'icon' => 'cs_icon_for_vc',
    'category' => esc_html__('CmsSuperheroes Shortcodes', 'buildana'),
    'description' => esc_html__('Add clients', 'buildana'),
    'params' => array(
        array(
            "type" => "cms_template",
            "param_name" => "cms_template",
            "heading" => esc_html__("Shortcode layout",'buildana'),
            "shortcode" => "cms_client",
        ),
        array(
            'type' => 'param_group',
            'heading' => esc_html__( 'Add your client', 'buildana' ),
            'param_name' => 'values',
            'value' => urlencode( json_encode( array(
                array(
                    'values' => esc_html__( 'Client', 'buildana' ),
                ),
            ) ) ),
            'params' => array(
                array(
                    "type" => "attach_image",
                    "param_name" => "image",
                    "heading" => esc_html__("Image Item",'buildana'),
                    "shortcode" => "cms_client",
                ),
                array(
                	'type' => 'vc_link',
                    'heading' => esc_html__( 'URL (Link)', 'buildana' ),
                    'param_name' => 'link',
                ),
            ),
            'group' => esc_html__('Client Item','buildana')
        ),
        array(
            "type" => "dropdown",
            "heading" => esc_html__("Columns XS Devices",'buildana'),
            "param_name" => "col_xs",
            "edit_field_class" => "vc_col-sm-3 vc_column",
            "value" => array(1,2,3,4,6,12),
            "std" => 1,
            "group" => esc_html__("Responsive Options", 'buildana')
        ),
        array(
            "type" => "dropdown",
            "heading" => esc_html__("Columns SM Devices",'buildana'),
            "param_name" => "col_sm",
            "edit_field_class" => "vc_col-sm-3 vc_column",
            "value" => array(1,2,3,4,6,12),
            "std" => 2,
            "group" => esc_html__("Responsive Options", 'buildana')
        ),
        array(
            "type" => "dropdown",
            "heading" => esc_html__("Columns MD Devices",'buildana'),
            "param_name" => "col_md",
            "edit_field_class" => "vc_col-sm-3 vc_column",
            "value" => array(1,2,3,4,6,12),
            "std" => 3,
            "group" => esc_html__("Responsive Options", 'buildana')
        ),
        array(
            "type" => "dropdown",
            "heading" => esc_html__("Columns LG Devices",'buildana'),
            "param_name" => "col_lg",
            "edit_field_class" => "vc_col-sm-3 vc_column",
            "value" => array(1,2,3,4,6,12),
            "std" => 4,
            "group" => esc_html__("Responsive Options", 'buildana')
        ),
        array(
            "type" => "textfield",
            "heading" => esc_html__("Extra Class",'buildana'),
            "param_name" => "class",
            "value" => "",
            "description" =>"",
        ),
    )
));

class WPBakeryShortCode_cms_client extends CmsShortCode
{
    protected function content($atts, $content = null){
        $atts_extra = shortcode_atts(array(
            'class' => '',
            'col_lg' => 4,
            'col_md' => 3,
            'col_sm' => 2,
            'col_xs' => 1,
            'cms_template' => 'cms_client.php',
        ), $atts);
        
		$atts = array_merge($atts_extra, $atts);
        
        $col_lg = 12 / $atts['col_lg'];
        $col_md = 12 / $atts['col_md'];
        $col_sm = 12 / $atts['col_sm'];
        $col_xs = 12 / $atts['col_xs'];
        $atts['item_class'] = "cms-client-item col-lg-{$col_lg} col-md-{$col_md} col-sm-{$col_sm} col-xs-{$col_xs}";
         
        $html_id = cmsHtmlID('cms-client');
        $atts['html_id'] = $html_id;
        return parent::content($atts, $content);
    }
}
?>