<?php
vc_map(array(
    "name" => 'Pricing Table',
    "base" => "cms_pricing",
    "icon" => "cs_icon_for_vc",
    "category" =>  esc_html__('CmsSuperheroes Shortcodes', 'buildana'),
    "description" =>  '',
    "params" => array(
         
        array(
            'type' => 'checkbox',
            'heading' => esc_html__("Is Active?", 'buildana'),
            'param_name' => 'is_active',
            'value' => array(
                'Yes' => true
            ),
            'std' => false,
        ),
        array(
            "type" => "textfield",
            "heading" =>esc_html__("Unit",'buildana'),
            "param_name" => "unit",
            "value"=>"$",
            "std"=>"$",
        ),
        array(
            "type" => "textfield",
            "heading" =>esc_html__("Price",'buildana'),
            "param_name" => "price",
            'description' => esc_html( '29'),
        ),  
        array(
            "type" => "textfield",
            "heading" =>esc_html__("Title",'buildana'),
            "param_name" => "title",
            'description' => esc_html( 'premium'),
        ),
        array(
            "type" => "textfield",
            "heading" =>esc_html__("Sub title",'buildana'),
            "param_name" => "sub_title",
            'description' => esc_html( 'per month'),
        ),
        array(
            'type' => 'param_group',
            'heading' => esc_html__( 'Features', 'buildana' ),
            'param_name' => 'features',
            'description' => esc_html__( 'Enter values for feature', 'buildana' ),
            'value' => urlencode( json_encode( array(
                array(
                    'values' => esc_html__( 'Value', 'buildana' ),
                ),
            ) ) ),
            'params' => array(
                array(
                    "type" => "textfield",
                    "heading" =>esc_html__("Attribute name",'buildana'),
                    "param_name" => "feature_name",
                    'admin_label' => true,
                ),
            ),
        ), 
        array(
            "type"        => "vc_link",
            "heading"     => esc_html__("URL (Link)",'buildana'),
            "param_name"  => "link",
            "value"       => "",
        ),
        array(
            "type"       => "dropdown",
            "heading"    => esc_html__("Type",'buildana'),
            "param_name" => "btn_type",
            "value"      => array(
                'Default' => 'btn-default',
                'Inverse' => 'btn-inverse',
            ),
            "std" => 'btn-default',
        ), 
        array(
            'type'       => 'css_editor',
            'heading'    => esc_html__( 'CSS box', 'buildana' ),
            'param_name' => 'css',
            'group'      => esc_html__( 'Design Options', 'buildana' ),
        ), 
    )
));

class WPBakeryShortCode_cms_pricing extends CmsShortCode
{
    protected function content($atts, $content = null){
        return parent::content($atts, $content);
    }
    
}

?>