<?php
vc_map(
	array(
		"name" => esc_html__("CMS Project", 'buildana'),
	    "base" => "cms_project",
	    "class" => "vc-cms-grid",
	    "category" => esc_html__("CmsSuperheroes Shortcodes", 'buildana'),
	    "params" => array(
	    	array(
	            "type" => "loop",
	            "heading" => esc_html__("Source",'buildana'),
	            "param_name" => "source",
	            'settings' => array(
	                'size' => array('hidden' => false, 'value' => 10),
	                'order_by' => array('value' => 'date')
	            ),
	            "group" => esc_html__("Source Settings", 'buildana'),
	        ),
	        array(
	            "type" => "cms_template",
	            "param_name" => "cms_template",
	            "shortcode" => "cms_project",
	            "admin_label" => true,
	            "heading" => esc_html__("Shortcode Template",'buildana'),
	            "group" => esc_html__("Template", 'buildana'),
	        ),
            array(
                'type' => 'checkbox',
                'heading' => esc_html__("Small space", 'buildana'),
                'param_name' => 'small_space',
                'value' => array(
                    'Yes' => true
                ),
                'std' => false,
                'dependency' => array(
                    'element' => 'cms_template',
                    'value'   => array(
                        'cms_project--style3.php',
                    ),
                ),
                "group" => esc_html__("Template", 'buildana'),
            ),
            array(
                'type' => 'checkbox',
                'heading' => esc_html__("Show pagination", 'buildana'),
                'param_name' => 'show_patination',
                'value' => array(
                    'Yes' => true
                ),
                'std' => true,
                "group" => esc_html__("Template", 'buildana'),
            ), 
            array(
                'type' => 'checkbox',
                'heading' => esc_html__("Top Overlap", 'buildana'),
                'param_name' => 'top_overlap',
                'value' => array(
                    'Yes' => true
                ),
                'std' => false,
                'dependency' => array(
                    'element' => 'cms_template',
                    'value'   => array(
                        'cms_project.php',
                    ),
                ),
                "group" => esc_html__("Template", 'buildana'),
            ),    
	    )
	)
);
class WPBakeryShortCode_cms_project extends CmsShortCode{
	protected function content($atts, $content = null){
		global $wp_query,$post;
		$atts_extra = shortcode_atts(array(
            'source' => '',
            'not__in'=> 'false', 
            'cms_template' => 'cms_project.php',
        ), $atts);
        
		$atts = array_merge($atts_extra, $atts);
        $html_id = cmsHtmlID('cms-project');
		//media script
		wp_enqueue_style( 'wp-mediaelement' );
		wp_enqueue_script( 'wp-mediaelement' );
		 
		wp_enqueue_script('cms-grid-pagination',get_template_directory_uri().'/assets/js/cmsgrid.pagination.js',array('jquery'),'1.0.0',true);
		  
        $source = $atts['source'];
        if (get_query_var('paged')){ 
        	$paged = get_query_var('paged'); 
        }
	    elseif(get_query_var('page')){ 
	    	$paged = get_query_var('page'); 
	    }
	    else{ 
	    	$paged = 1; 
	    }
        if(isset($atts['not__in']) && $atts['not__in']){
	    	list($args, $wp_query) = vc_build_loop_query($source, get_the_ID());
	    }
        else{
        	list($args, $wp_query) = vc_build_loop_query($source);
        }
         
        
        //default categories selected
        $args['cat_tmp'] = isset($args['cat'])?$args['cat']:'';
        // if select term on custom post type, move term item to cat.
        if(strstr($source, 'tax_query')){
        	$source_a = explode('|', $source);
        	foreach ($source_a as $key => $value) {
        		$tmp = explode(':', $value);
        		if($tmp[0] == 'tax_query'){
        			$args['cat_tmp'] = $tmp[1];
        		}
        	}
        }
	    if($paged > 1){
	    	$args['paged'] = $paged;
	    	$wp_query = new WP_Query($args);
	    }
        $atts['cat'] = isset($args['cat_tmp'])?$args['cat_tmp']:'';
        $atts['limit'] = isset($args['posts_per_page'])?$args['posts_per_page']:5;
        
        $atts['template'] = 'template-'.str_replace('.php','',$atts['cms_template']);
        $atts['html_id'] = $html_id;
        /* get posts */
        $atts['posts'] = $wp_query;
           
		return parent::content($atts, $content);
	}
}

?>