<?php
vc_map(array(
    'name' => 'CMS Testimonial Vertical Carousel',
    'base' => 'cms_testimonial_vertical_carousel',
    'icon' => 'cs_icon_for_vc',
    'category' => esc_html__('CmsSuperheroes Shortcodes', 'buildana'),
    'description' => esc_html__('Add clients testimonial', 'buildana'),
    'params' => array(
        array(
            'type' => 'img',
            'heading' => esc_html__('Layout Mode','buildana'),
            'param_name' => 'layout_mode',
                'value' =>  array(
                    'layout1' => get_template_directory_uri().'/vc_params/layouts/cms_testimonial_vertical.png',
                'std' => 'layout1',
            ),
        ),
        array(
            'type'          => 'param_group',
            'heading'       => esc_html__( 'Add your testimonial', 'buildana' ),
            'param_name'    => 'values',
            'value'         => urlencode( json_encode( array(
                array(
                    'author_name' => esc_html__( 'John Smith', 'buildana' ),
                ),
            ) ) ),
            'params' => array(
                array(
                    'type'          => 'textfield',
                    'heading'       => esc_html__( 'Author name', 'buildana' ),
                    'param_name'    => 'author_name',
                    'admin_label'   => true,
                    'value'         => esc_html__('John Smith','buildana')
                ),
                array(
                    'type'          => 'textfield',
                    'heading'       => esc_html__( 'Author Position', 'buildana' ),
                    'param_name'    => 'author_position',
                    'value'         => ''
                ),
                array(
                    'type'          => 'attach_image',
                    'heading'       => esc_html__( 'Author Image', 'buildana' ),
                    'param_name'    => 'author_avatar',
                    'value'         => ''
                ),
                array(
                    'type'          => 'textarea',
                    'heading'       => esc_html__( 'Testimonial text', 'buildana' ),
                    'description'   => esc_html__('Press double ENTER to get line-break','buildana'),
                    'param_name'    => 'text',
                    'value'         => ''
                ),
            ),
            'group' => esc_html__('Testimonial Item','buildana')
        ),
         
    )
));

 
class WPBakeryShortCode_cms_testimonial_vertical_carousel extends CmsShortCode
{
    protected function content($atts, $content = null){
        wp_enqueue_script('buildana-ver-carousel',get_template_directory_uri().'/assets/js/ver-carousel.js',array('jquery'),'1.0.0',true);
        return parent::content($atts, $content);
    }
}
?>