<?php
/**
 * ReduxFramework Sample Config File
 * For full documentation, please visit: http://docs.reduxframework.com/
 */
if (! class_exists('Redux')) {
    return;
}

// This line is only for altering the demo. Can be easily removed.
$opt_name = apply_filters('opt_name', 'opt_theme_options');

$theme = wp_get_theme(); // For use with some settings. Not necessary.

$args = array(
    // TYPICAL -> Change these values as you need/desire
    'opt_name' => $opt_name,
    // This is where your data is stored in the database and also becomes your global variable name.
    'display_name' => $theme->get('Name'),
    // Name that appears at the top of your panel
    'display_version' => $theme->get('Version'),
    // Version that appears at the top of your panel
    'menu_type' => 'menu',
    // Specify if the admin menu should appear or not. Options: menu or submenu (Under appearance only)
    'allow_sub_menu' => true,
    // Show the sections below the admin menu item or not
    'menu_title' => $theme->get('Name'),
    'page_title' => $theme->get('Name'),
    // You will need to generate a Google API key to use this feature.
    // Please visit: https://developers.google.com/fonts/docs/developer_api#Auth
    'google_api_key' => '',
    // Set it you want google fonts to update weekly. A google_api_key value is required.
    'google_update_weekly' => false,
    // Must be defined to add google fonts to the typography module
    'async_typography' => true,
    // Use a asynchronous font on the front end or font string
    // 'disable_google_fonts_link' => true, // Disable this in case you want to create your own google fonts loader
    'admin_bar' => true,
    // Show the panel pages on the admin bar
    'admin_bar_icon' => 'dashicons-smiley',
    // Choose an icon for the admin bar menu
    'admin_bar_priority' => 50,
    // Choose an priority for the admin bar menu
    'global_variable' => '',
    // Set a different name for your global variable other than the opt_name
    'dev_mode' => false,
    // Show the time the page took to load, etc
    'update_notice' => true,
    // If dev_mode is enabled, will notify developer of updated versions available in the GitHub Repo
    'customizer' => true,
    // Enable basic customizer support
    // 'open_expanded' => true, // Allow you to start the panel in an expanded way initially.
    'disable_save_warn' => true, // Disable the save warning when a user changes a field

    // OPTIONAL -> Give you extra features
    'page_priority' => null,
    // Order where the menu appears in the admin area. If there is any conflict, something will not show. Warning.
    'page_parent' => 'themes.php',
    // For a full list of options, visit: http://codex.wordpress.org/Function_Reference/add_submenu_page#Parameters
    'page_permissions' => 'manage_options',
    // Permissions needed to access the options panel.
    'menu_icon' => 'dashicons-dashboard',
    // Specify a custom URL to an icon
    'last_tab' => '',
    // Force your panel to always open to a specific tab (by id)
    'page_icon' => 'dashicons-smiley',
    // Icon displayed in the admin panel next to your menu_title
    'page_slug' => '',
    // Page slug used to denote the panel, will be based off page title then menu title then opt_name if not provided
    'save_defaults' => true,
    // On load save the defaults to DB before user clicks save or not
    'default_show' => false,
    // If true, shows the default value next to each field that is not the default value.
    'default_mark' => '',
    // What to print by the field's title if the value shown is default. Suggested: *
    'show_import_export' => true,
    // Shows the Import/Export panel when not used as a field.

    // CAREFUL -> These options are for advanced use only
    'transient_time' => 60 * MINUTE_IN_SECONDS,
    'output' => true,
    // Global shut-off for dynamic CSS output by the framework. Will also disable google fonts output
    'output_tag' => true,
    // Allows dynamic CSS to be generated for customizer and google fonts, but stops the dynamic CSS from going to the head
    // 'footer_credit' => '', // Disable the footer credit of Redux. Please leave if you can help it.

    // FUTURE -> Not in use yet, but reserved or partially implemented. Use at your own risk.
    'database' => '',
    // possible: options, theme_mods, theme_mods_expanded, transient. Not fully functional, warning!
    'use_cdn' => true,
    // If you prefer not to use the CDN for Select2, Ace Editor, and others, you may download the Redux Vendor Support plugin yourself and run locally or embed it in your code.

    // HINTS
    'hints' => array(
        'icon' => 'el el-question-sign',
        'icon_position' => 'right',
        'icon_color' => 'lightgray',
        'icon_size' => 'normal',
        'tip_style' => array(
            'color' => 'red',
            'shadow' => true,
            'rounded' => false,
            'style' => ''
        ),
        'tip_position' => array(
            'my' => 'top left',
            'at' => 'bottom right'
        ),
        'tip_effect' => array(
            'show' => array(
                'effect' => 'slide',
                'duration' => '500',
                'event' => 'mouseover'
            ),
            'hide' => array(
                'effect' => 'slide',
                'duration' => '500',
                'event' => 'click mouseleave'
            )
        )
    )
);

Redux::setArgs($opt_name, $args);

/**
 * General Options.
 */
Redux::setSection($opt_name, array(
    'title' => esc_html__('General', 'buildana'),
    'icon' => 'el-icon-adjust-alt',
    'fields' => array(
        array(
            'title'     => esc_html__('Boxed Layout', 'buildana'),
            'subtitle'  => esc_html__('make your site is boxed?', 'buildana'),
            'id'        => 'general_layout',
            'type'      => 'switch',
            'default'   => false
        ),
        array(
            'title'     => esc_html__('Boxed width', 'buildana'),
            'subtitle'  => esc_html__('This option just applied for screen larger than value you enter here!', 'buildana'),
            'id'        => 'body_width',
            'type'      => 'dimensions',
            'units'     => array('px'),
            'height'    => false,
            'default'   => array(
                'width' => '1500px',
                'units' => 'px'
            ),
            'required'  => array( 'general_layout', '=', 1),
        ),
        array(
            'title'             => esc_html__('Body Background', 'buildana'),
            'id'                => 'general_background',
            'type'              => 'background',
            'preview'           => false,
            'output'            => array( 'body' ),
            'required'  => array( 'general_layout', '=', 1),
        ),
        array(
            'title'             => esc_html__('Content Background', 'buildana'),
            'id'                => 'content_background',
            'type'              => 'background',
            'preview'           => false,
            'output'            => array( '.site-content' ),
            'required'  => array( 'general_layout', '=', 1),
        ),
        array(
            'subtitle'          => esc_html__('Enable back to top button.', 'buildana'),
            'id'                => 'general_back_to_top',
            'type'              => 'switch',
            'title'             => esc_html__('Back To Top', 'buildana'),
            'default'           => true,
        )
    )
));



/**
 * Header Options
 * 
 * @author Fox
 */
Redux::setSection($opt_name, array(
    'title' => esc_html__('Header', 'buildana'),
    'icon' => 'el-icon-credit-card',
    'fields' => array(
        
        array(
            'id'                => 'header_layout',
            'title'             => esc_html__('Layouts', 'buildana'),
            'subtitle'          => esc_html__('select a layout for header', 'buildana'),
            'default'           => 'layout1',
            'type'              => 'image_select',
            'options'           => array(
                                        'layout1' => get_template_directory_uri().'/assets/images/header/layout-1.png',
                                        'layout2' => get_template_directory_uri().'/assets/images/header/layout-2.png',
                                        'layout3' => get_template_directory_uri().'/assets/images/header/layout-3.png',
                                        'layout4' => get_template_directory_uri().'/assets/images/header/layout-4.png',
                                       
                                    ),
                      
        ),
        array(
            'id'                => 'header_middle_background_color',
            'type'              => 'color_rgba',
            'title'             => esc_html__( 'Header Middle Background Color', 'buildana' ),
            'subtitle'          => esc_html__( 'Header middle background color', 'buildana' ),
            'output'   => array(
                'background-color' => '.header-middle'
            ),
            'required'  => array( 'header_layout', '=', 'layout1'),      
        ),
        array(
            'title'             => esc_html__('Header Middle Background Image', 'buildana'),
            'subtitle'          => esc_html__('Header middle background image.', 'buildana'),
            'id'                => 'header_middle_background_image',
            'type'              => 'background',
            'preview'           => true,
            'background-color'  => false,
            'output'            => array( '.header-middle' ),
            'required'  => array( 'header_layout', '=', 'layout1'),      
        ),
       
        array(
            'title'             => esc_html__('Header middle padding', 'buildana'),
            'subtitle'          => esc_html__('Padding top and bottom', 'buildana'),
            'id'                => 'header_middle_padding',
            'type'              => 'spacing',
            'mode'              => 'padding',
            'units'             => array( 'em', 'px', '%' ),
            'top'               => true,
            'right'             => false,
            'bottom'            => true,
            'left'              => false,
            'output'            => array( '.header-middle .header-middle-wrap' ),
            'required'  => array( 'header_layout', '=', 'layout1'),      
        ),
        array(
            'id'                => 'header_middle_heading_color',
            'type'              => 'color',
            'title'             => esc_html__( 'Header Middle Text Heading color', 'buildana' ),
            'output'            => '.header-layout1 .contact-info-middle span,.header-layout1 .work-hour span',
            'required'  => array( 'header_layout', '=', 'layout1'),      
        ),
        array(
            'id'                => 'header_middle_text_color',
            'type'              => 'color',
            'title'             => esc_html__( 'Header Middle Text color', 'buildana' ),
            'output'            => '.header-layout1, .header-layout1 p',
            'required'  => array( 'header_layout', '=', 'layout1'),      
        ),
        array(
            'id'                => 'header1_menu_background_color',
            'type'              => 'color_rgba',
            'title'             => esc_html__( 'Main menu Background Color', 'buildana' ),
            'output'   => array(
                'background-color' => '.header-layout1 .cshero-main-header:not(.affix) .container .main-header-outer'
            ),
            'required'  => array( 'header_layout', '=', 'layout1'),      
        ),

        array(
            'id'                => 'header_background_color',
            'type'              => 'color_rgba',
            'title'             => esc_html__( 'Background Color', 'buildana' ),
            'subtitle'          => esc_html__( 'Header background color', 'buildana' ),
            'output'   => array(
                'background-color' => '#cshero-header .main-header-wrap,.header-layout2 .cshero-main-header:not(.affix) .container'
            ),
            'required'  => array( 'header_layout', '=', array('layout2','layout3','layout4')),      
        ),
          
        array(
            'title'             => esc_html__('Header padding', 'buildana'),
            'subtitle'          => esc_html__('Padding top and bottom', 'buildana'),
            'id'                => 'header_padding',
            'type'              => 'spacing',
            'mode'              => 'padding',
            'units'             => array( 'em', 'px', '%' ),
            'top'               => true,
            'right'             => false,
            'bottom'            => true,
            'left'              => false,
            'required'  => array( 'header_layout', '=', array('layout2','layout3','layout4')),  
        ),
        array(
            'title'             => esc_html__('Header margin bottom', 'buildana'),
            'subtitle'          => esc_html__('Apply for screen >= 1200px', 'buildana'),
            'id'                => 'header_margin_bottom',
            'type'              => 'spacing',
            'mode'              => 'margin',
            'units'             => array( 'em', 'px', '%' ),
            'top'               => false,
            'right'             => false,
            'bottom'            => true,
            'left'              => false,
            'required'  => array( 'header_layout', '=', array('layout2')),      
        ),
          
    )
));

/* Header top */
Redux::setSection($opt_name, array(
    'icon' => 'el-icon-minus',
    'title' => esc_html__('Header top', 'buildana'),
    'subsection' => true,
    'fields' => array(
        array(
            'title'     => esc_html__('Enable', 'buildana'),
            'id'        => 'enable_header_top',
            'type'      => 'switch',
            'default'   => true
        ),
        array(
            'id'                => 'header_top_layout',
            'title'             => esc_html__('Layouts', 'buildana'),
            'subtitle'          => esc_html__('select a layout for header', 'buildana'),
            'default'           => 'layout1',
            'type'              => 'image_select',
            'options'           => array(
                                        'layout1' => get_template_directory_uri().'/assets/images/header-top/layout1.png',
                                        'layout2' => get_template_directory_uri().'/assets/images/header-top/layout2.png',
                                    ),
            'required'  => array( 'enable_header_top', '=', 1),          
        ),
        array(
            'subtitle'          => esc_html__('Full width', 'buildana'),
            'id'                => 'header_top_full_width',
            'type'              => 'switch',
            'title'             => esc_html__('Full Width', 'buildana'),
            'default'           => false,
            'required'  => array( 'enable_header_top', '=', 1),
        ), 
        array(
            'id'                => 'header_top_background',
            'type'              => 'color_rgba',
            'title'             => esc_html__( 'Background Color', 'buildana' ),
            'subtitle'          => esc_html__( 'Header top background color', 'buildana' ),
            'output'   => array(
                'background-color' => '.header-top,.header-top.layout2'
            ),
            'required'  => array( 'enable_header_top', '=', 1),
        ),
        array(
            'id'                => 'header_top_text_color',
            'type'              => 'color',
            'title'             => esc_html__( 'Text color', 'buildana' ),
            'output'            => '.header-top,.header-top .widget,.header-top p,.header-top .widget_text ul li,.header-top.layout2 .contact-info-top',
            'required'  => array( 'enable_header_top', '=', 1),
        ),
        array(
            'id'                => 'header_top_link_color',
            'type'              => 'link_color',
            'title'             => esc_html__( 'Links Color', 'buildana' ),
            'subtitle'          => esc_html__( 'Select links color in header top', 'buildana' ),
            'regular'           => true,
            'hover'             => true,
            'active'            => false,
            'visited'           => false,
            'output'            => array( '.header-top a, .header-top ul li a,.header-top .cms-socials a,.header-top.layout2 .cms-socials a,.header-top .widget_nav_menu ul li a'),
            'required'  => array( 'enable_header_top', '=', 1),
        ),
        array(
            'id' => 'header_top_border_color',
            'type' => 'color',
            'title' => esc_html__('Border color', 'buildana'),
            'output'    => array(
                'border-color' => '.header-top,.header-top.layout1 .header-top-right .widget,.header-top .widget_authenticate .fs-link a:first-child:after',
                'background-color' => '.header-top .widget_nav_menu ul li + li a:before',
            ),
            'required'  => array( 'enable_header_top', '=', 1),
        ),  
 
    )
)); 
/* Header logo */
Redux::setSection($opt_name, array(
    'icon' => 'el-icon-minus',
    'title' => esc_html__('Logo', 'buildana'),
    'subsection' => true,
    'fields' => array(
        array(
            'title'             => esc_html__('Select Logo', 'buildana'),
            'subtitle'          => esc_html__('Select an image file for your logo.', 'buildana'),
            'id'                => 'main_logo',
            'type'              => 'media',
            'url'               => false,
            'default'           => array(
                'url'=>get_template_directory_uri().'/assets/images/logo.png'
            ),
        ),
         
        array(
            'subtitle'          => esc_html__('Set max height for logo.', 'buildana'),
            'id'                => 'logo_max_height',
            'type'              => 'dimensions',
            'units'             => array('px'),
            'width'             => false,
            'title'             => esc_html__('Logo Max Height', 'buildana'),
        ),
         
        
    )
));
/* Main menu */
Redux::setSection($opt_name, array(
    'icon' => 'el-icon-minus',
    'title' => esc_html__('Main menu', 'buildana'),
    'subsection' => true,
    'fields' => array(
          
        array(
            'id'                => 'main_menu_level1_link_color',
            'type'              => 'link_color',
            'title'             => esc_html__( 'Link color', 'buildana' ),
            'regular'           => true,
            'hover'             => true,
            'active'            => false,
            'visited'           => false,
            'output'            => array( 
                '#cshero-header-navigation .main-navigation .menu-main-menu > li > a'
            ),
        ),
        
        array(
            'id'                => 'main_menu_level1_current_color',
            'type'              => 'link_color',
            'title'             => esc_html__( 'Current color', 'buildana' ),
            'regular'           => true,
            'hover'             => false,
            'active'            => false,
            'visited'           => false,
            'output'            => array(  
                '#cshero-header-navigation .main-navigation .menu-main-menu > li.current-menu-ancestor > a,  
                #cshero-header-navigation .main-navigation .menu-main-menu > li.current-menu-item > a',
            ),
        ),
        array(
            'title'             => esc_html__('Menu item space', 'buildana'),
            'subtitle'          => esc_html__('Number of px between menu item', 'buildana'),
            'id'                => 'menu_item_space',
            'type'              => 'spacing',
            'mode'              => 'padding',
            'units'             => array( 'em', 'px', '%' ),
            'top'               => false,
            'right'             => true,
            'bottom'            => false,
            'left'              => true,
            'output'            => array( '#cshero-header-navigation .main-navigation .menu-main-menu > li > a' )
        ),
        
        array(
            'title'             => esc_html__('Typography', 'buildana'),
            'id'                => 'main_menu_level1_typography',
            'type'              => 'typography',
            'google'            => true,
            'text-align'        => false,
            'color'             => false,
            'line-height'       => true,
            'font-size'         => true,
            'output'            => array( 
                '#cshero-header-navigation .main-navigation ul.nav-menu > li > a' 
            ),
        ),
         
    )
));
/* Menu Sticky */
Redux::setSection($opt_name, array(
    'icon' => 'el-icon-minus',
    'title' => esc_html__('Menu Sticky', 'buildana'),
    'subsection' => true,
    'fields' => array(
        array(
            'subtitle'          => esc_html__('enable sticky mode for menu.', 'buildana'),
            'id'                => 'menu_sticky',
            'type'              => 'switch',
            'title'             => esc_html__('Sticky Header', 'buildana'),
            'default'           => false,
        ),
        array(
            'title'             => esc_html__('Select Logo', 'buildana'),
            'subtitle'          => esc_html__('Select an image file for your logo.', 'buildana'),
            'id'                => 'sticky_logo',
            'type'              => 'media',
            'url'               => false,
            'default'           => array(
                'url'=>get_template_directory_uri().'/assets/images/logo.png'
            ),
            'required'          => array( 'menu_sticky', '=', 1 )
        ),
         
        array(
            'subtitle'          => esc_html__('Set max height for sticky logo.', 'buildana'),
            'id'                => 'sticky_logo_max_height',
            'type'              => 'dimensions',
            'units'             => array('px'),
            'width'             => false,
            'title'             => esc_html__('Sticky Logo Max Height', 'buildana'),
            'required'          => array( 'menu_sticky', '=', 1 )
        ),
        array(
            'title'             => esc_html__('Sticky header padding', 'buildana'),
            'subtitle'          => esc_html__('Padding top and bottom', 'buildana'),
            'id'                => 'sticky_header_padding',
            'type'              => 'spacing',
            'mode'              => 'padding',
            'units'             => array( 'em', 'px', '%' ),
            'top'               => true,
            'right'             => false,
            'bottom'            => true,
            'left'              => false,
            'output'            => array( '.cshero-main-header.affix .main-navigation ul.nav-menu > li > a,.header-layout4 .affix .header-search-cart a' ),
            'required'          => array( 'menu_sticky', '=', 1 )
        ),  
    )
));
 
/**
 * Page Title
 *
 * @author Fox
 */
Redux::setSection($opt_name, array(
    'title' => esc_html__('Page Title & BC', 'buildana'),
    'icon' => 'el-icon-map-marker',
    'fields' => array(
        array(
            'id'                => 'page_title_layout',
            'title'             => esc_html__('Layouts', 'buildana'),
            'subtitle'          => esc_html__('select a layout for page title', 'buildana'),
            'default'           => '1',
            'type'              => 'image_select',
            'options'           => array(
                                    '1' => get_template_directory_uri().'/assets/images/pagetitle/style1.png',
                                    '2' => get_template_directory_uri().'/assets/images/pagetitle/style2.png',
                                )
        ),

         
        array(
            'id'                => 'page_title_background_color',
            'type'              => 'color_rgba',
            'title'             => esc_html__( 'Background color', 'buildana' ),
            'output'   => array(
                'background' => '.page-title .bg-overlay',
            ),
        ),
        
        array(
            'title'             => esc_html__('Background image', 'buildana'),
            'subtitle'          => esc_html__('Page title background image.', 'buildana'),
            'id'                => 'page_title_background_image',
            'type'              => 'background',
            'preview'           => true,
            'background-color'  => false,
            'output'            => array( '.page-title' )

        ),
        array(
            'title'             => esc_html__('Page title Typography', 'buildana'),
            'subtitle'          => esc_html__('Page title typography.', 'buildana'),
            'id'                => 'page_title_typography',
            'type'              => 'typography',
            'text-align'        => false,
            'font-size'         => false,
            'line-height'       => false,
            'google'            => true,
            'output'            => array( '.page-title .page-title-text h2' )
        ),
         
        array(
            'title'             => esc_html__('Padding', 'buildana'),
            'subtitle'          => esc_html__('Page title padding (top/bottom).', 'buildana'),
            'id'                => 'page_title_padding',
            'type'              => 'spacing',
            'mode'              => 'padding',
            'units'             => array( 'em', 'px', '%' ),
            'top'               => true,
            'right'             => false,
            'bottom'            => true,
            'left'              => false,
            'output'            => array( '.page-title' )
        ),
        array(
            'id'        => 'page_title_align',
            'title'     => esc_html__('Align', 'buildana'),
            'type'      => 'button_set',
            'options' => array(
                'text-left'     => esc_html__('Left','buildana'), 
                'text-center'     => esc_html__('Center','buildana'),
                'text-right'     => esc_html__('Right','buildana'), 
            ), 
            'default'   => 'text-center',
            'required'          => array('page_title_layout','=','1')
        ),
        
    )
));

/* Breadcrumb */
Redux::setSection($opt_name, array(
    'icon' => 'el-icon-random',
    'title' => esc_html__('Breadcrumb', 'buildana'),
    'subsection' => true,
    'fields' => array(
        array(
            'title'             => esc_html__('Breadcrumb Typography', 'buildana'),
            'subtitle'          => esc_html__('Breadcrumb typography.', 'buildana'),
            'id'                => 'breadcrumb_typography',
            'type'              => 'typography',
            'text-align'        => false,
            'font-size'         => false,
            'line-height'       => false,
            'google'            => true,
            'output'            => array( '.breadcrumb-text,.breadcrumb-text a,.breadcrumb-text span,.page-title.layout-5 .brc-wrap,.page-title.layout-6 .brc-wrap' )
        ),
        array(
            'id'                => 'breadcrumb_link_color',
            'type'              => 'link_color',
            'title'             => esc_html__( 'Link Color', 'buildana' ),
            'active'            => false,
            'subtitle'          => esc_html__( 'Select link color in breadcrumb', 'buildana' ),
            'output'            => array( '.breadcrumb-text a, .breadcrumb-text a span, .page-title.layout-5 .brc-wrap a, .page-title.layout-5 .brc-wrap a span, .page-title.layout-6 .brc-wrap a, .page-title.layout-6 .brc-wrap a span' ),
        ),
    )
));

/**
 * Content
 *
 * css color.
 * @author Fox
 */
Redux::setSection($opt_name, array(
    'title' => esc_html__('Content', 'buildana'),
    'icon' => 'el-icon-pencil',
    'fields' => array(
        array(
            'title'     => esc_html__('Padding', 'buildana'),
            'subtitle'  => esc_html__('Choose padding for content tag', 'buildana'),
            'id'        => 'content_padding',
            'type'      => 'spacing',
            'mode'      => 'padding',
            'right' => false,
            'left' => false,
            'units'     => array('px'),     
            'output'    => array('.site-content')
        ),
    )
));
/* page */
Redux::setSection($opt_name, array(
    'title' => esc_html__('Page', 'buildana'),
    'icon' => 'el-icon-list',
    'subsection' => true,
    'fields' => array(
        array(
            'subtitle'          => esc_html__('Show editor', 'buildana'),
            'id'                => 'page_show_frontend_editor',
            'type'              => 'switch',
            'title'             => esc_html__('Frontend editor', 'buildana'),
            'default'           => false,
        ),
    )
));
/* archive */
Redux::setSection($opt_name, array(
    'title' => esc_html__('Archive', 'buildana'),
    'icon' => 'el-icon-list',
    'subsection' => true,
    'fields' => array(
        array(
            'id'                => 'archive_layout',
            'title'             => esc_html__('Layouts', 'buildana'),
            'subtitle'          => esc_html__('select a layout for archive, search, index...', 'buildana'),
            'default'           => 'right',
            'type'              => 'image_select',
            'options'           => array(
                                        'left' => get_template_directory_uri().'/assets/images/content/right.png',
                                        'full' => get_template_directory_uri().'/assets/images/content/full.png',
                                        'right' => get_template_directory_uri().'/assets/images/content/left.png',
                                    )
        ),
        array(
            'subtitle'          => esc_html__('Show date time.', 'buildana'),
            'id'                => 'archive_date',
            'type'              => 'switch',
            'title'             => esc_html__('Date', 'buildana'),
            'default'           => true,
        ),  
        array(
            'subtitle'          => esc_html__('Show comment count.', 'buildana'),
            'id'                => 'archive_comment',
            'type'              => 'switch',
            'title'             => esc_html__('Comment', 'buildana'),
            'default'           => true,
        ),
        array(
            'subtitle'          => esc_html__('Show author.', 'buildana'),
            'id'                => 'archive_author',
            'type'              => 'switch',
            'title'             => esc_html__('Author', 'buildana'),
            'default'           => false,
        ), 
        array(
            'subtitle'          => esc_html__('Show categories.', 'buildana'),
            'id'                => 'archive_categories',
            'type'              => 'switch',
            'title'             => esc_html__('Categories', 'buildana'),
            'default'           => false,
        ),
        array(
            'subtitle'          => esc_html__('Show tags.', 'buildana'),
            'id'                => 'archive_tag',
            'type'              => 'switch',
            'title'             => esc_html__('Tags', 'buildana'),
            'default'           => false,
        ),
        array(
            'subtitle'          => esc_html__('Show triangular in thumbnail bottom.', 'buildana'),
            'id'                => 'archive_triangular',
            'type'              => 'switch',
            'title'             => esc_html__('Show triangular in thumbnail bottom', 'buildana'),
            'default'           => true,
        ),
        array(
            'subtitle'          => esc_html__('Show link icon', 'buildana'),
            'id'                => 'archive_link_icon',
            'type'              => 'switch',
            'title'             => esc_html__('Show link icon', 'buildana'),
            'default'           => true,
            'required'  => array( 'archive_triangular', '=', 1),     
        ),
        array(
            'subtitle'          => esc_html__('Excerpt length enter by ( number of word )', 'buildana'),
            'id'                => 'excerpt_length',
            'type'              => 'text',
            'default'           => 60,
            'title'             => esc_html__('Excerpt length', 'buildana'),
        ),
    )
));

/* Single */
Redux::setSection($opt_name, array(
    'title' => esc_html__('Single', 'buildana'),
    'icon' => 'el-icon-file-edit',
    'subsection' => true,
    'fields' => array(
        array(
            'id'                => 'single_layout',
            'title'             => esc_html__('Layouts', 'buildana'),
            'subtitle'          => esc_html__('select a layout for single...', 'buildana'),
            'default'           => 'right',
            'type'              => 'image_select',
            'options'           => array(
                                        'left' => get_template_directory_uri().'/assets/images/content/right.png',
                                        'full' => get_template_directory_uri().'/assets/images/content/full.png',
                                        'right' => get_template_directory_uri().'/assets/images/content/left.png',
                                    )
        ),
        array(
            'id'                => 'single_post_set_title_is_page_title',
            'title'             => esc_html__('Move post title to page title section', 'buildana'),
            'subtitle'          => esc_html__('Move post title to page title section', 'buildana'),
            'type'              => 'switch',
            'default'           => false,
        ),
        array(
            'id'                => 'custom_single_post_title',
            'title'             => esc_html__('Custom the post title text', 'buildana'),
            'subtitle'          => esc_html__('Default is: \'Single post\'', 'buildana'),
            'type'              => 'text',
            'default'           => esc_html__('Single post', 'buildana'),
            'required'          => array( 'single_post_set_title_is_page_title', '=', false )
        ),
        array(
            'subtitle'          => esc_html__('Show date time.', 'buildana'),
            'id'                => 'single_date',
            'type'              => 'switch',
            'title'             => esc_html__('Date', 'buildana'),
            'default'           => true,
        ),
        array(
            'subtitle'          => esc_html__('Show comment count.', 'buildana'),
            'id'                => 'single_comment',
            'type'              => 'switch',
            'title'             => esc_html__('Comment', 'buildana'),
            'default'           => true,
        ),
        array(
            'subtitle'          => esc_html__('Show tags.', 'buildana'),
            'id'                => 'single_tag',
            'type'              => 'switch',
            'title'             => esc_html__('Tags', 'buildana'),
            'default'           => false,
        ),
        array(
            'subtitle'          => esc_html__('Show triangular in thumbnail bottom.', 'buildana'),
            'id'                => 'single_triangular',
            'type'              => 'switch',
            'title'             => esc_html__('Show triangular in thumbnail bottom', 'buildana'),
            'default'           => true,
        ),
        array(
            'subtitle'          => esc_html__('Show sharing icon', 'buildana'),
            'id'                => 'single_sharing_icon',
            'type'              => 'switch',
            'title'             => esc_html__('Show sharing icon', 'buildana'),
            'default'           => true,
            'required'  => array( 'single_triangular', '=', 1),     
        ),
        
        array(
            'title' => esc_html__('ENTRY FOOTER', 'buildana'),
            'id'   => 'entry-footer-panel',
            'type' => 'info',
            'style' => 'success',
        ),
        array(
            'subtitle'          => esc_html__('Show category.', 'buildana'),
            'id'                => 'single_footer_category',
            'type'              => 'switch',
            'title'             => esc_html__('Category', 'buildana'),
            'default'           => true,
        ),
        array(
            'subtitle'          => esc_html__('Show author', 'buildana'),
            'id'                => 'single_footer_author',
            'type'              => 'switch',
            'title'             => esc_html__('Author', 'buildana'),
            'default'           => true,
        ),
        array(
            'title' => esc_html__('COMMENT FORM', 'buildana'),
            'id'   => 'comment-form-panel',
            'type' => 'info',
            'style' => 'success',
        ),
        array(
            'subtitle'          => esc_html__('Show comment form', 'buildana'),
            'id'                => 'single_comment_form',
            'type'              => 'switch',
            'title'             => esc_html__('Comment form', 'buildana'),
            'default'           => true,
        ),
        array(
            'title' => esc_html__('POST NAVIGATION', 'buildana'),
            'id'   => 'post-nav-panel',
            'type' => 'info',
            'style' => 'success',
        ),
        array(
            'subtitle'          => esc_html__('Show post navigation', 'buildana'),
            'id'                => 'single_post_nav',
            'type'              => 'switch',
            'title'             => esc_html__('Post navigation', 'buildana'),
            'default'           => false,
        ),
    )
));

/**
 * Project
 *
 * css color.
 * @author Fox
 */
Redux::setSection($opt_name, array(
    'title' => esc_html__('Single Project', 'buildana'),
    'icon' => 'el-icon-file-edit',
    'subsection' => true,
    'fields' => array(
        array(
            'id'        => 'project_single_style',
            'title'     => esc_html__('Style', 'buildana'),
            'type'      => 'button_set',
            'options' => array(
                'style1'     => esc_html__('Style 1','buildana'), 
                'style2'     => esc_html__('Style 2','buildana'),
            ), 
            'default'   => 'style1',
        ),
        array(
            'id'                => 'single_project_set_title_is_page_title',
            'title'             => esc_html__('Move title to page title section', 'buildana'),
            'subtitle'          => esc_html__('Move title to page title section', 'buildana'),
            'type'              => 'switch',
            'default'           => false,
        ),
        array(
            'id'                => 'custom_single_project_title',
            'title'             => esc_html__('Custom the project single title text', 'buildana'),
            'subtitle'          => esc_html__('Default is: \'Single project\'', 'buildana'),
            'type'              => 'text',
            'default'           => esc_html__('Single service', 'buildana'),
            'required'          => array( 'single_project_set_title_is_page_title', '=', false )
        ),
    )
));
/**
 * Team
 *
 * @author Fox
 */
Redux::setSection($opt_name, array(
    'title' => esc_html__('Single Team', 'buildana'),
    'icon' => 'el-icon-file-edit',
    'subsection' => true,
    'fields' => array(
        array(
            'id'                => 'single_team_set_title_is_page_title',
            'title'             => esc_html__('Move title to page title section', 'buildana'),
            'subtitle'          => esc_html__('Move title to page title section', 'buildana'),
            'type'              => 'switch',
            'default'           => false,
        ),
        array(
            'id'                => 'custom_single_team_title',
            'title'             => esc_html__('Custom the event single title text', 'buildana'),
            'subtitle'          => esc_html__('Default is: \'Single team\'', 'buildana'),
            'type'              => 'text',
            'default'           => esc_html__('Single team', 'buildana'),
            'required'          => array( 'single_team_set_title_is_page_title', '=', false )
        ),
    )
));
/**
 * Services
 *
 * @author Fox
 */
Redux::setSection($opt_name, array(
    'title' => esc_html__('Single Services', 'buildana'),
    'icon' => 'el-icon-file-edit',
    'subsection' => true,
    'fields' => array(
        array(
            'id'                => 'single_services_set_title_is_page_title',
            'title'             => esc_html__('Move title to page title section', 'buildana'),
            'subtitle'          => esc_html__('Move title to page title section', 'buildana'),
            'type'              => 'switch',
            'default'           => false,
        ),
        array(
            'id'                => 'custom_single_services_title',
            'title'             => esc_html__('Custom the services single title text', 'buildana'),
            'subtitle'          => esc_html__('Default is: \'Single service\'', 'buildana'),
            'type'              => 'text',
            'default'           => esc_html__('Single service', 'buildana'),
            'required'          => array( 'single_services_set_title_is_page_title', '=', false )
        ),
    )
));
/**
 * Styling
 * 
 * css color.
 * @author Fox
 */
Redux::setSection($opt_name, array(
    'title' => esc_html__('Styling', 'buildana'),
    'icon' => 'el-icon-adjust',
    'fields' => array(
        
        array(
            'subtitle' => esc_html__('Set primary color.', 'buildana'),
            'id' => 'primary_color',
            'type' => 'color',
            'title' => esc_html__('Primary Color', 'buildana'),
            'default' => '#fdb415',
        ),
        
        array(
            'id'       => 'link_color',
            'type'     => 'link_color',
            'title'    => esc_html__( 'Links Color', 'buildana' ),
            'subtitle' => esc_html__( 'Select Links Color Option', 'buildana' ),
            'regular'   => true,
            'hover'     => true,
            'active'    => false,
            'visited'   => false,
            'default'           => array(
                'regular'           => '#444444',
                'hover'             => '#fdb415',
            ),
        ),
        
        array(
            'id'       => 'button_default_color',
            'type'     => 'link_color',
            'title'    => esc_html__( 'Button Default Color', 'buildana' ),
            'subtitle' => esc_html__( 'Select Button Default Color Option', 'buildana' ),
            'regular'   => true,
            'hover'     => true,
            'active'    => false,
            'visited'   => false,
        ),  
        array(
            'id'       => 'button_primary_color',
            'type'     => 'link_color',
            'title'    => esc_html__( 'Button Primary Color', 'buildana' ),
            'subtitle' => esc_html__( 'Select Button Primary Color Option', 'buildana' ),
            'regular'   => true,
            'hover'     => true,
            'active'    => false,
            'visited'   => false,
        ),
    )
));
 

/**
 * Typography
 * 
 * @author Fox
 */
Redux::setSection($opt_name, array(
    'title' => esc_html__('Typography', 'buildana'),
    'icon' => 'el-icon-text-width',
    'fields' => array(
        array(
            'id' => 'font_body',
            'type' => 'typography',
            'title' => esc_html__('Body Font', 'buildana'),
            'google' => true,
            'font-backup' => true,
            'all_styles' => true,
            'output'  => array('body,body.ds'),
            'units' => 'px',
            'subtitle' => esc_html__('Typography option with each property can be called individually.', 'buildana'),
        ),
        array(
            'id' => 'font_h1',
            'type' => 'typography',
            'title' => esc_html__('H1', 'buildana'),
            'google' => true,
            'font-backup' => true,
            'all_styles' => true,
            'line-height' => false,
            'output'  => array('h1'),
            'units' => 'px',
            'subtitle' => esc_html__('Typography option with each property can be called individually.', 'buildana'),
        ),
        array(
            'id' => 'font_h2',
            'type' => 'typography',
            'title' => esc_html__('H2', 'buildana'),
            'google' => true,
            'font-backup' => true,
            'all_styles' => true,
            'line-height' => false,
            'output'  => array('h2'),
            'units' => 'px',
            'subtitle' => esc_html__('Typography option with each property can be called individually.', 'buildana'),
        ),
        array(
            'id' => 'font_h3',
            'type' => 'typography',
            'title' => esc_html__('H3', 'buildana'),
            'google' => true,
            'font-backup' => true,
            'all_styles' => true,
            'line-height' => false,
            'output'  => array('h3'),
            'units' => 'px',
            'subtitle' => esc_html__('Typography option with each property can be called individually.', 'buildana'),
        ),
        array(
            'id' => 'font_h4',
            'type' => 'typography',
            'title' => esc_html__('H4', 'buildana'),
            'google' => true,
            'font-backup' => true,
            'all_styles' => true,
            'line-height' => false,
            'output'  => array('h4'),
            'units' => 'px',
            'subtitle' => esc_html__('Typography option with each property can be called individually.', 'buildana'),
        ),
        array(
            'id' => 'font_h5',
            'type' => 'typography',
            'title' => esc_html__('H5', 'buildana'),
            'google' => true,
            'font-backup' => true,
            'all_styles' => true,
            'line-height' => false,
            'output'  => array('h5'),
            'units' => 'px',
            'subtitle' => esc_html__('Typography option with each property can be called individually.', 'buildana'),
        ),
        array(
            'id' => 'font_h6',
            'type' => 'typography',
            'title' => esc_html__('H6', 'buildana'),
            'google' => true,
            'font-backup' => true,
            'all_styles' => true,
            'line-height' => false,
            'output'  => array('h6'),
            'units' => 'px',
            'subtitle' => esc_html__('Typography option with each property can be called individually.', 'buildana'),
        )
    )
));
 
/* extra font. */
$custom_font_1 = Redux::getOption($opt_name, 'google-font-selector-1');
$custom_font_1 = !empty($custom_font_1) ? explode(',', $custom_font_1) : array();

Redux::setSection($opt_name, array(
    'title' => esc_html__('Extra Fonts', 'buildana'),
    'icon' => 'el el-fontsize',
    'subsection' => true,
    'fields' => array(
        array(
            'id' => 'google-font-1',
            'type' => 'typography',
            'title' => esc_html__('Custom Font', 'buildana'),
            'google' => true,
            'font-backup' => true,
            'all_styles' => true,
            'output'  =>  $custom_font_1,
            'units' => 'px',
            'subtitle' => esc_html__('Typography option with each property can be called individually.', 'buildana'),
            'default' => array(
                'color' => '',
                'font-style' => '',
                'font-weight' => '',
                'font-family' => '',
                'google' => true,
                'font-size' => '',
                'line-height' => '',
                'text-align' => ''
            )
        ),
        array(
            'id' => 'google-font-selector-1',
            'type' => 'textarea',
            'title' => esc_html__('Selector 1', 'buildana'),
            'subtitle' => esc_html__('add html tags ID or class (body,a,.class,#id)', 'buildana'),
            'validate' => 'no_html',
            'default' => '',
        )
        
    )
));

/**
 * Footer
 *
 * @author Fox
 */
Redux::setSection($opt_name, array(
    'title' => esc_html__('Footer', 'buildana'),
    'icon' => 'el el-website',
    'fields' => array()
));

/* Newsleter */
Redux::setSection($opt_name, array(
    'title' => esc_html__('Newsleter', 'buildana'),
    'icon' => 'el el-minus',
    'subsection' => true,
    'fields' => array(
        array(
            'title'     => esc_html__('Enable', 'buildana'),
            'subtitle'  => esc_html__('Enable newsletter', 'buildana'),
            'id'        => 'footer_enable_newsletter',
            'type'      => 'switch',
            'default'   => true
        ),
        array(
            'title'     => esc_html__('Boxed Layout', 'buildana'),
            'subtitle'  => esc_html__('make your newsletter is boxed?', 'buildana'),
            'id'        => 'newsletter_boxed',
            'type'      => 'switch',
            'default'   => false,
            'required'  => array('footer_enable_newsletter','=',1)
        ),
        array(
            'id'                => 'footer_newsletter_background_color',
            'type'              => 'color_rgba',
            'title'             => esc_html__( 'Background color', 'buildana' ),
            'output'   => array(
                'background-color' => '.footer-newsletter .bg-overlay'
            ),
            'required'  => array('footer_enable_newsletter','=',1)
        ),
        array(
            'title'             => esc_html__('Background image', 'buildana'),
            'subtitle'          => esc_html__('background image', 'buildana'),
            'id'                => 'footer_newsletter_background_image',
            'type'              => 'background',
            'background-color'  => false,
            'output'            => array( '.footer-newsletter' ),
            'required'  => array('footer_enable_newsletter','=',1)
        ),
        array(
            'subtitle' => esc_html__('Title color.', 'buildana'),
            'id' => 'footer_newsletter_title_color',
            'type' => 'color',
            'title' => esc_html__('Title Color', 'buildana'),
            'output'    => array('.footer-newsletter .wg-title'),
            'required'  => array('footer_enable_newsletter','=',1)
        ),
        array(
            'title'             => esc_html__('Padding', 'buildana'),
            'subtitle'          => esc_html__('Footer newsletter padding (top/bottom).', 'buildana'),
            'id'                => 'footer_newsletter_padding',
            'type'              => 'spacing',
            'mode'              => 'padding',
            'units'             => array('px'),
            'right'             => false,
            'left'              => false,
            'output'            => array( '.footer-newsletter' ),
            'required'  => array('footer_enable_newsletter','=',1)
        ),
    )
));

/* footer top. */
Redux::setSection($opt_name, array(
    'title' => esc_html__('Footer Top', 'buildana'),
    'icon' => 'el el-minus',
    'subsection' => true,
    'fields' => array(
        array(
            'title'     => esc_html__('Disable', 'buildana'),
            'subtitle'  => esc_html__('Disable footer top', 'buildana'),
            'id'        => 'disable_footer_top',
            'type'      => 'switch',
            'default'   => false
        ),
        
        array(
            'id'       => 'footer-top-column',
            'type'     => 'select',
            'title'    => esc_html__( 'Column', 'buildana' ),
            'subtitle' => esc_html__( 'Select Footer Column', 'buildana' ),
            'default'    => 4,
            'options'  => array(
                1 => esc_html__('1', 'buildana' ),
                2 => esc_html__('2', 'buildana' ),
                3 => esc_html__('3', 'buildana' ),
                4 => esc_html__('4', 'buildana' ),
            ),
            'required'  => array('disable_footer_top','=',0)
        ),
         
        array(
            'id'                => 'footer_top_background_color',
            'type'              => 'color_rgba',
            'title'             => esc_html__( 'Background color', 'buildana' ),
            'output'   => array(
                'background-color' => 'footer .footer-top .bg-overlay'
            ),
            'required'  => array('disable_footer_top','=',0)
        ),
        
        array(
            'title'             => esc_html__('Background image', 'buildana'),
            'subtitle'          => esc_html__('Footer top background image', 'buildana'),
            'id'                => 'footer_top_background_image',
            'type'              => 'background',
            'background-color'  => false,
            'output'            => array( 'footer .footer-top' ),
            'required'  => array('disable_footer_top','=',0)
        ),
         
        array(
            'title'             => esc_html__('Padding', 'buildana'),
            'subtitle'          => esc_html__('Footer top padding (top/bottom).', 'buildana'),
            'id'                => 'footer_top_padding',
            'type'              => 'spacing',
            'mode'              => 'padding',
            'units'             => array('px'),
            'right'             => false,
            'left'              => false,
            'default'            => array(
                'padding-top'     => '117px', 
                'padding-bottom'  => '40px', 
                'units'          => 'px', 
            ),
            'output'            => array( 'footer .footer-top' ),
            'required'  => array('disable_footer_top','=',0)
        ),
         
        array(
            'subtitle' => esc_html__('Title color.', 'buildana'),
            'id' => 'footer_top_title_color',
            'type' => 'color',
            'title' => esc_html__('Title Color', 'buildana'),
            'output'    => array('.footer-top .wg-title'),
            'required'          => array('disable_footer_top','=',0)
        ),
        array(
            'subtitle' => esc_html__('Text color.', 'buildana'),
            'id' => 'footer_top_text_color',
            'type' => 'color',
            'title' => esc_html__('Text Color', 'buildana'),
            'output'    => array('.footer-top,.footer-top p,.footer-top .widget_text'),
            'required'          => array('disable_footer_top','=',0)
        ),
        array(
            'id'       => 'footer_top_link_color',
            'type'     => 'link_color',
            'title'    => esc_html__( 'Links Color', 'buildana' ),
            'subtitle' => esc_html__( 'Select Links Color Option', 'buildana' ),
            'regular'   => true,
            'hover'     => true,
            'active'    => false,
            'visited'   => false,
            'output'   => array( '.footer-top a,.footer-top ul li a,.footer-top .widget_nav_menu ul li a' ),
            'required'          => array('disable_footer_top','=',0)
        ),
         
    )
));

/* footer bottom. */
Redux::setSection($opt_name, array(
    'title' => esc_html__('Footer Bottom', 'buildana'),
    'icon' => 'el el-minus',
    'subsection' => true,
    'fields' => array(
         
        array(
            'id'       => 'footer-bottom-copyright-text',
            'type'     => 'textarea',
            'title'    => esc_html__( 'Footer bottom copyright text', 'buildana' ),
            'subtitle' => esc_html__( 'Input the html content', 'buildana' ),
            'validate' => 'html_custom',
            'default'  => wp_kses('&copy; 2017 <a href="#">Buildana theme</a> by <a href="#">Spyropress</a>',true),
            'allowed_html'=> array(
                'a' => array(
                    'class' => array(),  
                    'href' => array(),
                    'title' => array()
                ),
                'span' => array(
                    'class' => array()
                ),
                'br' => array(),
                'em' => array(),
                'strong' => array()
            ),
            
        ),
        array(
            'title'             => esc_html__('Background', 'buildana'),
            'subtitle'          => esc_html__('Footer bottom background.', 'buildana'),
            'id'                => 'footer_bottom_background',
            'type'              => 'background',
            'output'            => array( '.footer-bottom' ),
        ),
         
        array(
            'id'       => 'footer_bottom_link_color',
            'type'     => 'link_color',
            'title'    => esc_html__( 'Links Color', 'buildana' ),
            'subtitle' => esc_html__( 'Select Links Color Option', 'buildana' ),
            'regular'   => true,
            'hover'     => true,
            'active'    => false,
            'visited'   => false,
            'output'   => array( '.footer-bottom a,.footer-bottom ul li a' ),
        ),
        array(
            'subtitle' => esc_html__('Text color.', 'buildana'),
            'id' => 'footer_bottom_text_color',
            'type' => 'color',
            'title' => esc_html__('Text Color', 'buildana'),
            'output'    => array('.footer-bottom,.footer-bottom p,.footer-bottom span,.footer-bottom .copyright')
        ),
        array(
            'title'             => esc_html__('Padding', 'buildana'),
            'subtitle'          => esc_html__('Footer top padding (top/bottom).', 'buildana'),
            'id'                => 'footer_bottom_padding',
            'type'              => 'spacing',
            'mode'              => 'padding',
            'units'             => array('px'),
            'right'             => false,
            'left'              => false,
            'output'            => array( '.footer-bottom' )
        ),
          
    )
));


/**
 * Shop option
 * 
 * extra css for customer.
 * @author Fox
 */
/**
 * Shop option
 * 
 * extra css for customer.
 * @author Fox
 */
Redux::setSection($opt_name, array(
    'title' => esc_html__('Woocommerces', 'buildana'),
    'icon' => 'el el-shopping-cart',
    'fields' => array(
       
        array(
            'id'                => 'woo_loop_layout',
            'title'             => esc_html__('Shop catalog layout', 'buildana'),
            'subtitle'          => esc_html__('select a layout for catalog shop page', 'buildana'),
            'default'           => 'full',
            'type'              => 'image_select',
            'options'           => array(
                                        'left' => get_template_directory_uri().'/assets/images/content/right.png',
                                        'full' => get_template_directory_uri().'/assets/images/content/full.png',
                                        'right' => get_template_directory_uri().'/assets/images/content/left.png',
                                    )
        ),
        array(
            'subtitle' => esc_html__('Select catalog product column', 'buildana'),
            'id' => 'shop_columns',
            'type' => 'select',
            'title' => esc_html__('Products Columns', 'buildana'),
            'options'=>array(
                '2'=> esc_html__('2 Columns','buildana'),
                '3'=> esc_html__('3 Columns','buildana'),
            ),
            'default' => '3',
            'required'          => array( 'woo_loop_layout', '=', array('left','right') )
        ),
        array(
            'subtitle' => esc_html__('Select catalog product column', 'buildana'),
            'id' => 'shop_columns_full',
            'type' => 'select',
            'title' => esc_html__('Products Columns', 'buildana'),
            'options'=>array(
                '2'=> esc_html__('2 Columns','buildana'),
                '3'=> esc_html__('3 Columns','buildana'),
                '4'=> esc_html__('4 Columns','buildana'),
            ),
            'default' => '4',
            'required'          => array( 'woo_loop_layout', '=', 'full' )
        ),
        array(
            'subtitle' => esc_html__('Enter the number of products you want to show on catalog layout', 'buildana'),
            'id' => 'shop_products',
            'type' => 'text',
            'title' => esc_html__('Number Product Per Page', 'buildana'),
            'default' => '8',
        ),
        array(
            'id'                => 'shop_loop_product_bg',
            'type'              => 'color_rgba',
            'title'             => esc_html__( ' Product\'s background at archive pages', 'buildana' ),
            'default'   => array(
                'color'     => '#fbfcfc',
                'alpha'     => 1
            ), 
            'output'   => array(
                'background-color' => '.wc-product-wrap'
            ),
        ),
        array(
            'title' => esc_html__('SINGLE SHOP', 'buildana'),
            'id'   => 'entry-footer-panel',
            'type' => 'info',
            'style' => 'success',
        ),
        array(
            'id'                => 'woo_single_layout',
            'title'             => esc_html__('Product single layout', 'buildana'),
            'subtitle'          => esc_html__('select a layout for single product page', 'buildana'),
            'default'           => 'full',
            'type'              => 'image_select',
            'options'           => array(
                                        'left' => get_template_directory_uri().'/assets/images/content/right.png',
                                        'full' => get_template_directory_uri().'/assets/images/content/full.png',
                                        'right' => get_template_directory_uri().'/assets/images/content/left.png',
                                    )
        ),
        array(
            'id'                => 'single_shop_set_title_is_page_title',
            'title'             => esc_html__('Move title to page title section', 'buildana'),
            'subtitle'          => esc_html__('Move title to page title section', 'buildana'),
            'type'              => 'switch',
            'default'           => false,
        ),
        array(
            'id'                => 'custom_single_shop_title',
            'title'             => esc_html__('Custom the shop single title text', 'buildana'),
            'subtitle'          => esc_html__('Default is: \'Single shop\'', 'buildana'),
            'type'              => 'text',
            'default'           => esc_html__('Single shop', 'buildana'),
            'required'          => array( 'single_shop_set_title_is_page_title', '=', false )
        ),
          
    )
));
/**
 * GutenBerg
 * 
 * Supported GutenBerg or Not
 * @author Chinh Duong Manh
 * @since 2.2
 */
Redux::setSection($opt_name, array(
    'title'  => esc_html__('Gutenberg', 'buildana'),
    'icon'   => 'el-icon-edit',
    'fields' => array(
        array(
            'id'        => 'gutenberg',
            'title'     => esc_html__('Gutenberg Editor', 'buildana'),
            'type'      => 'button_set',
            'options'   => array(
                ''  =>  esc_html__('Default','buildana'), 
                'disable'  =>  esc_html__('Disable','buildana'),
            ),
            'default'   => 'disable'
        )
    )
));
/**
 * Optimal Core
 * 
 * Optimal options for theme. optimal speed
 * @author Fox
 */
Redux::setSection($opt_name, array(
    'title' => esc_html__('Optimal Core', 'buildana'),
    'icon' => 'el-icon-idea',
    'fields' => array(
        array(
            'subtitle' => esc_html__('no minimize , generate css over time...', 'buildana'),
            'id' => 'dev_mode',
            'type' => 'switch',
            'title' => esc_html__('Dev Mode (not recommended)', 'buildana'),
            'default' => false
        )
    )
));