<?php
/**
 * Meta box config file
 */
if (! class_exists('MetaFramework')) {
    return;
}

$args = array(
    // TYPICAL -> Change these values as you need/desire
    'opt_name' => apply_filters('opt_meta', 'opt_meta_options'),
    // Set a different name for your global variable other than the opt_name
    'dev_mode' => false,
    // Allow you to start the panel in an expanded way initially.
    'open_expanded' => false,
    // Disable the save warning when a user changes a field
    'disable_save_warn' => true,
    // Page slug used to denote the panel, will be based off page title then menu title then opt_name if not provided
    'save_defaults' => false,

    'output' => false,
    // Global shut-off for dynamic CSS output by the framework. Will also disable google fonts output
    'output_tag' => false,
    // Show the time the page took to load, etc
    'update_notice' => false,
    // 'disable_google_fonts_link' => true, // Disable this in case you want to create your own google fonts loader
    'admin_bar' => false,
    // Specify if the admin menu should appear or not. Options: menu or submenu (Under appearance only)
    'allow_sub_menu' => false,
    // If dev_mode is enabled, will notify developer of updated versions available in the GitHub Repo
    'customizer' => false,
    // What to print by the field's title if the value shown is default. Suggested: *
    'show_import_export' => false,
    // possible: options, theme_mods, theme_mods_expanded, transient. Not fully functional, warning!
    'use_cdn' => false,
    // save meta to multiple keys.
    'meta_mode' => 'multiple'
);

// -> Set Option To Panel.
MetaFramework::setArgs($args);

add_action('admin_init', 'buildana_meta_boxs');

MetaFramework::init();

function buildana_meta_boxs()
{

    /** page options */
    MetaFramework::setMetabox(array(
        'id' => '_page_main_options',
        'label' => esc_html__('Page Setting', 'buildana'),
        'post_type' => 'page',
        'context' => 'advanced',
        'priority' => 'default',
        'open_expanded' => false,
        'sections' => array(
            array(
                'title' => esc_html__('General', 'buildana'),
                'id' => 'tab-page-general',
                'icon' => 'el el-credit-card',
                'fields' => array(
                    array(
                        'title'     => esc_html__('Boxed Layout', 'buildana'),
                        'subtitle'  => esc_html__('make your site is boxed?', 'buildana'),
                        'id'        => 'opt_general_layout',
                        'type'      => 'switch',
                        'default'   => false
                    ),
                    array(
                        'title'     => esc_html__('Boxed width', 'buildana'),
                        'subtitle'  => esc_html__('This option just applied for screen larger than value you enter here!', 'buildana'),
                        'id'        => 'body_width',
                        'type'      => 'dimensions',
                        'units'     => array('px'),
                        'height'    => false,
                        'default'   => array(
                            'width' => '1500px',
                            'units' => 'px'
                        ),
                        'required'  => array( 'opt_general_layout', '=', 1),
                    ), 
                    array(
                        'title'             => esc_html__('Body Background', 'buildana'),
                        'id'                => 'opt_general_background',
                        'type'              => 'background',
                        'preview'           => false,
                        'required'  => array( 'opt_general_layout', '=', 1),
                    ),  
                    array(
                        'title'             => esc_html__('Content Background', 'buildana'),
                        'id'                => 'opt_content_background',
                        'type'              => 'background',
                        'preview'           => false,
                        'required'  => array( 'opt_general_layout', '=', 1),
                    ),   
                )
            ),
            array(
                'title' => esc_html__('Header', 'buildana'),
                'id' => 'tab-page-header',
                'icon' => 'el el-credit-card',
                'fields' => array(
                    array(
                        'id' => 'header_layout',
                        'title' => esc_html__('Layouts', 'buildana'),
                        'subtitle' => esc_html__('select a layout for header', 'buildana'),
                        'default' => '',
                        'type' => 'image_select',
                        'options' => array(
                            '' => get_template_directory_uri() . '/assets/images/header/h-page-default.png',
                            'layout1' => get_template_directory_uri().'/assets/images/header/layout-1.png',
                            'layout2' => get_template_directory_uri().'/assets/images/header/layout-2.png',
                            'layout3' => get_template_directory_uri().'/assets/images/header/layout-3.png',
                            'layout4' => get_template_directory_uri().'/assets/images/header/layout-4.png',
                            'layout5' => get_template_directory_uri().'/assets/images/header/layout-5.png',
                        ),
                    ),
                    
                    array(
                        'id' => 'header_menu',
                        'type' => 'select',
                        'title' => esc_html__('Select Menu', 'buildana'),
                        'subtitle' => esc_html__('custom menu for current page', 'buildana'),
                        'options' => buildana_get_nav_menu(),
                        'default' => '',
                    ),
                )
            ),
            array(
                'title' => esc_html__('Header Top', 'buildana'),
                'id' => 'tab-page-header-top',
                'icon' => 'el el-credit-card',
                'fields' => array(
                    array(
                        'title'     => esc_html__('Enable', 'buildana'),
                        'id'        => 'enable_header_top',
                        'type'      => 'switch',
                        'default'   => true
                    ),
                    array(
                        'id' => 'header_top_layout',
                        'title' => esc_html__('Layouts', 'buildana'),
                        'subtitle' => esc_html__('select a layout for header top', 'buildana'),
                        'default' => '',
                        'type' => 'image_select',
                        'options' => array(
                            '' => get_template_directory_uri().'/assets/images/header-top/layout1.png',
                            'layout2' => get_template_directory_uri().'/assets/images/header-top/layout2.png',
                        ),
                        'required'  => array( 'enable_header_top', '=', 1),       
                    ),
                        
                )
            ),
            array(
                'title' => esc_html__('Page Title & BC', 'buildana'),
                'id' => 'tab-page-title-bc',
                'icon' => 'el el-map-marker',
                'fields' => array(
                    array(
                        'subtitle' => esc_html__('Disable Page title for current page.', 'buildana'),
                        'id' => 'disable_page_title',
                        'type' => 'switch',
                        'title' => esc_html__('Disable', 'buildana'),
                        'default' => false,
                    ),
                    array(
                        'id' => 'page_title_layout',
                        'title' => esc_html__('Layouts', 'buildana'),
                        'subtitle' => esc_html__('select a layout for page title', 'buildana'),
                        'default' => '',
                        'type' => 'image_select',
                        'options' => array(
                            '' => get_template_directory_uri().'/assets/images/pagetitle/default.png',
                            '1' => get_template_directory_uri().'/assets/images/pagetitle/style1.png',
                            '2' => get_template_directory_uri().'/assets/images/pagetitle/style2.png',
                            '3' => get_template_directory_uri().'/assets/images/pagetitle/style3.png',
                            '4' => get_template_directory_uri().'/assets/images/pagetitle/style4.png',
                            '5' => get_template_directory_uri().'/assets/images/pagetitle/style5.png',
                            '6' => get_template_directory_uri().'/assets/images/pagetitle/style6.png',
                        ),
                        'required' => array( 0 => 'disable_page_title', 1 => '=', 2 => 0 )
                    ),
                    array(
                        'id' => 'page_title_text',
                        'type' => 'text',
                        'title' => esc_html__('Custom Title', 'buildana'),
                        'subtitle' => esc_html__('Custom current page title.', 'buildana'),
                        'required' => array( 0 => 'disable_page_title', 1 => '=', 2 => 0 )
                    ),
                )
            ),
            array(
                'title' => esc_html__('Content', 'buildana'),
                'id' => 'tab-content',
                'icon' => 'el el-pencil',
                'fields' => array(
                    array(
                        'title'     => esc_html__('Padding', 'buildana'),
                        'subtitle'  => esc_html__('Choose padding for content tag', 'buildana'),
                        'id'        => 'content_padding',
                        'type'      => 'spacing',
                        'mode'      => 'padding',
                        'right' => false,
                        'left' => false,
                        'units'     => array('px'),     
                    ),
                    
                )
            ),
            array(
                'title' => esc_html__('Footer', 'buildana'),
                'id' => 'tab-content',
                'icon' => 'el el-pencil',
                'fields' => array(
                    array(
                        'title'     => esc_html__('Enable', 'buildana'),
                        'subtitle'  => esc_html__('Enable newsletter', 'buildana'),
                        'id'        => 'footer_enable_newsletter',
                        'type'      => 'switch',
                        'default'   => true
                    ),
                    array(
                        'title'     => esc_html__('Boxed Layout', 'buildana'),
                        'subtitle'  => esc_html__('make your newsletter is boxed?', 'buildana'),
                        'id'        => 'newsletter_boxed',
                        'type'      => 'switch',
                        'default'   => false,
                        'required'  => array('footer_enable_newsletter','=',1)
                    ),
                )
            ),  
        )
    ));

    /** post options */
    MetaFramework::setMetabox(array(
        'id' => '_page_post_format_options',
        'label' => esc_html__('Post Format', 'buildana'),
        'post_type' => 'post',
        'context' => 'advanced',
        'priority' => 'default',
        'open_expanded' => true,
        'sections' => array(
            array(
                'title' => '',
                'id' => 'color-Color',
                'icon' => 'el el-laptop',
                'fields' => array(
                    array(
                        'id' => 'opt-video-type',
                        'type' => 'select',
                        'title' => esc_html__('Select Video Type', 'buildana'),
                        'subtitle' => esc_html__('Local video, Youtube, Vimeo', 'buildana'),
                        'options' => array(
                            'local' => esc_html__('Upload', 'buildana'),
                            'youtube' => esc_html__('Youtube', 'buildana'),
                            'vimeo' => esc_html__('Vimeo', 'buildana'),
                        )
                    ),
                    array(
                        'id' => 'otp-video-local',
                        'type' => 'media',
                        'url' => true,
                        'mode' => false,
                        'title' => esc_html__('Local Video', 'buildana'),
                        'subtitle' => esc_html__('Upload video media using the WordPress native uploader', 'buildana'),
                        'required' => array('opt-video-type', '=', 'local')
                    ),
                    array(
                        'id' => 'opt-video-youtube',
                        'type' => 'text',
                        'title' => esc_html__('Youtube', 'buildana'),
                        'subtitle' => esc_html__('Load video from Youtube.', 'buildana'),
                        'placeholder' => esc_html__('https://youtu.be/iNJdPyoqt8U', 'buildana'),
                        'required' => array('opt-video-type', '=', 'youtube')
                    ),
                    array(
                        'id' => 'opt-video-vimeo',
                        'type' => 'text',
                        'title' => esc_html__('Vimeo', 'buildana'),
                        'subtitle' => esc_html__('Load video from Vimeo.', 'buildana'),
                        'placeholder' => esc_html__('https://vimeo.com/155673893', 'buildana'),
                        'required' => array('opt-video-type', '=', 'vimeo')
                    ),
                    array(
                        'id' => 'otp-video-thumb',
                        'type' => 'media',
                        'url' => true,
                        'mode' => false,
                        'title' => esc_html__('Video Thumb', 'buildana'),
                        'subtitle' => esc_html__('Upload thumb media using the WordPress native uploader', 'buildana'),
                        'required' => array('opt-video-type', '=', 'local')
                    ),
                    array(
                        'id' => 'otp-audio',
                        'type' => 'media',
                        'url' => true,
                        'mode' => false,
                        'title' => esc_html__('Audio Media', 'buildana'),
                        'subtitle' => esc_html__('Upload audio media using the WordPress native uploader', 'buildana'),
                    ),
                    array(
                        'id' => 'opt-gallery',
                        'type' => 'gallery',
                        'title' => esc_html__('Add/Edit Gallery', 'buildana'),
                        'subtitle' => esc_html__('Create a new Gallery by selecting existing or uploading new images using the WordPress native uploader', 'buildana'),
                    ),
                    array(
                        'id' => 'opt-quote-title',
                        'type' => 'text',
                        'title' => esc_html__('Quote Title', 'buildana'),
                        'subtitle' => esc_html__('Quote title or quote name...', 'buildana'),
                    ),
                    array(
                        'id' => 'opt-quote-sub-title',
                        'type' => 'text',
                        'title' => esc_html__('Quote Sub Title', 'buildana'),
                        'subtitle' => esc_html__('Quote sub title or quote position...', 'buildana'),
                    ),
                    array(
                        'id' => 'opt-quote-content',
                        'type' => 'textarea',
                        'title' => esc_html__('Quote Content', 'buildana'),
                    ),
                    array(
                        'id' => 'opt-status',
                        'type' => 'media',
                        'title' => esc_html__('Add/Edit Status image', 'buildana'),
                        'subtitle' => esc_html__('uploading new images using the WordPress native uploader', 'buildana'),
                    ),
                )
            ),
        )
    ));
    /** Services options */
    MetaFramework::setMetabox(array(
        'id' => '_page_services_format_options',
        'label' => esc_html__('Services Option', 'buildana'),
        'post_type' => 'services',
        'context' => 'advanced',
        'priority' => 'default',
        'open_expanded' => true,
        'sections' => array(
            array(
                'title' => '',
                'id' => 'color-Color',
                'icon' => 'el el-laptop',
                'fields' => array(
                    array(
                        'title'             => esc_html__('Select an image icon', 'buildana'),
                        'subtitle'          => esc_html__('Select an image icon file for this service.', 'buildana'),
                        'id'                => 'service_icon_image',
                        'type'              => 'media',
                        'url'               => false,
                    ),
                    array(
                        'id' => 'service_icon',
                        'type' => 'text',
                        'title' => esc_html__('Icon class (web font icon)', 'buildana'),
                        'subtitle' => esc_html__('Show icon when do not select image icon', 'buildana'),
                    ),
                    array(
                        'id' => 'service_intro_text',
                        'type' => 'textarea',
                        'title' => esc_html__('Intro text', 'buildana'),
                        'subtitle' => esc_html__('add html tags ID or class (body,a,.class,#id)', 'buildana'),
                        'validate' => 'no_html',
                        'default' => '',
                    ),
                    array(
                        'id' => 'service_work_hour',
                        'type' => 'text',
                        'title' => esc_html__('Work hour', 'buildana'),
                        'subtitle' => esc_html__('Enter the work hour text for this service', 'buildana'),
                    ),
                    array(
                        'id' => 'service_email',
                        'type' => 'text',
                        'title' => esc_html__('Email', 'buildana'),
                        'subtitle' => esc_html__('Enter the email for contact', 'buildana'),
                    ),
                    array(
                        'id' => 'service_phone',
                        'type' => 'text',
                        'title' => esc_html__('Phone', 'buildana'),
                        'subtitle' => esc_html__('Enter the phone for contact', 'buildana'),
                    ),
                )
            ),
             
        )
    ));
    
    /** Project options */
    MetaFramework::setMetabox(array(
        'id' => '_page_project_format_options',
        'label' => esc_html__('Project Option', 'buildana'),
        'post_type' => 'project',
        'context' => 'advanced',
        'priority' => 'default',
        'open_expanded' => true,
        'sections' => array(
            array(
                'title' => '',
                'id' => 'color-Color',
                'icon' => 'el el-laptop',
                'fields' => array(
                     
                    array(
                        'id' => 'project_client',
                        'type' => 'text',
                        'title' => esc_html__('Client', 'buildana'),
                    ),
                    array(
                        'id' => 'project_location',
                        'type' => 'text',
                        'title' => esc_html__('Location', 'buildana'),
                    ),
                    array(
                        'id' => 'project_started',
                        'type' => 'text',
                        'title' => esc_html__('Started', 'buildana'),
                    ),
                    array(
                        'id' => 'project_completed',
                        'type' => 'text',
                        'title' => esc_html__('Completed', 'buildana'),
                    ),
                )
            ),
             
        )
    ));
    /** Team options */
    MetaFramework::setMetabox(array(
        'id' => '_page_team_format_options',
        'label' => esc_html__('Team Option', 'buildana'),
        'post_type' => 'team',
        'context' => 'advanced',
        'priority' => 'default',
        'open_expanded' => true,
        'sections' => array(
            array(
                'title' => '',
                'id' => 'color-Color',
                'icon' => 'el el-laptop',
                'fields' => array(
                    array(
                        'id' => 'opt_team_position',
                        'type' => 'text',
                        'title' => esc_html__('Position', 'buildana'),
                        'subtitle' => esc_html__('Enter the position for this team', 'buildana'),
                    ),
                    array(
                        'id' => 'opt_team_intro_text',
                        'type' => 'textarea',
                        'title' => esc_html__('Intro text', 'buildana'),
                        'validate' => 'no_html',
                        'default' => '',
                    ),
                    array(
                        'id' => 'opt_team_dob',
                        'type' => 'text',
                        'title' => esc_html__('Date of birth', 'buildana'),
                    ),
                    array(
                        'id' => 'opt_team_email',
                        'type' => 'text',
                        'title' => esc_html__('Email address', 'buildana'),
                    ),
                    array(
                        'id' => 'opt_team_phone',
                        'type' => 'text',
                        'title' => esc_html__('Phone no', 'buildana'),
                    ),
                    array(
                        'id' => 'opt_team_address',
                        'type' => 'text',
                        'title' => esc_html__('Address', 'buildana'),
                    ),
                    array(
                        'id' => 'opt_team_social_link_1',
                        'type' => 'text',
                        'title' => esc_html__('Social link 1', 'buildana'),
                        'subtitle' => esc_html__('Enter the social link 1', 'buildana'),
                    ),
                    array(
                        'id' => 'opt_team_social_icon_class_1',
                        'type' => 'text',
                        'title' => esc_html__('Social icon class 1', 'buildana'),
                        'subtitle' => esc_html__('Enter the social icon class 1 (fa fa-facebook,fa fa-twitter,fa fa-google...)', 'buildana'),
                    ),
                    array(
                        'id' => 'opt_team_social_link_2',
                        'type' => 'text',
                        'title' => esc_html__('Social link 2', 'buildana'),
                        'subtitle' => esc_html__('Enter the social link 2', 'buildana'),
                    ),
                    array(
                        'id' => 'opt_team_social_icon_class_2',
                        'type' => 'text',
                        'title' => esc_html__('Social icon class 2', 'buildana'),
                        'subtitle' => esc_html__('Enter the social icon class 2 (fa fa-facebook,fa fa-twitter,fa fa-google...)', 'buildana'),
                    ),
                    array(
                        'id' => 'opt_team_social_link_3',
                        'type' => 'text',
                        'title' => esc_html__('Social link 3', 'buildana'),
                        'subtitle' => esc_html__('Enter the social link 3', 'buildana'),
                    ),
                    array(
                        'id' => 'opt_team_social_icon_class_3',
                        'type' => 'text',
                        'title' => esc_html__('Social icon class 3', 'buildana'),
                        'subtitle' => esc_html__('Enter the social icon class 3 (fa fa-facebook,fa fa-twitter,fa fa-google...)', 'buildana'),
                    ),
                    array(
                        'id' => 'opt_team_social_link_4',
                        'type' => 'text',
                        'title' => esc_html__('Social link 4', 'buildana'),
                        'subtitle' => esc_html__('Enter the social link 4', 'buildana'),
                    ),
                    array(
                        'id' => 'opt_team_social_icon_class_4',
                        'type' => 'text',
                        'title' => esc_html__('Social icon class 4', 'buildana'),
                        'subtitle' => esc_html__('Enter the social icon class 4 (fa fa-facebook,fa fa-twitter,fa fa-google...)', 'buildana'),
                    ),
                    array(
                        'id' => 'opt_team_social_link_5',
                        'type' => 'text',
                        'title' => esc_html__('Social link 5', 'buildana'),
                        'subtitle' => esc_html__('Enter the social link 5', 'buildana'),
                    ),
                    array(
                        'id' => 'opt_team_social_icon_class_5',
                        'type' => 'text',
                        'title' => esc_html__('Social icon class 5', 'buildana'),
                        'subtitle' => esc_html__('Enter the social icon class 5 (fa fa-facebook,fa fa-twitter,fa fa-google...)', 'buildana'),
                    ),
                )
            ),
             
        )
    ));
}