<?php
add_action( 'tgmpa_register', 'cms_theme_register_required_plugins' );
/**
 * Register the required plugins for this theme.
 *
 * In this example, we register two plugins - one included with the TGMPA library
 * and one from the .org repo.
 *
 * The variable passed to tgmpa_register_plugins() should be an array of plugin
 * arrays.
 *
 * This function is hooked into tgmpa_init, which is fired within the
 * TGM_Plugin_Activation class constructor.
*/
function cms_theme_register_required_plugins() {

    /**
     * Array of plugin arrays. Required keys are name and slug.
     * If the source is NOT from the .org repo, then source is also required.
     */
    $plugins = array(
        array(
            'name'               => esc_html__('EF4-Framework','buildana'),
            'slug'               => 'ef4-Framework',
            'source'             => 'ef4-framework-v2.1.0.zip',
            'required'           => true,
        ),
        array(
            'name'               => esc_html__('Visual Composer','buildana'),
            'slug'               => 'js_composer',
            'source'             => 'js_composer.zip',
            'required'           => true,
        ),
        array(
            'name'               => esc_html__('Revolution Slider','buildana'),
            'slug'               => 'revslider',
            'source'             => 'revslider.zip',
            'required'           => true,
        ),
        array(
            'name'               => esc_html__('Flex Login','buildana'),
            'slug'               => 'flex-user',
            'source'             => 'flex-user.zip',
            'required'           => false,
        ),
        array(
            'name'               => esc_html__('Custom Post Type UI','buildana'),
            'slug'               => 'custom-post-type-ui',
            'required'           => true,
        ),
        array(
            'name'               => esc_html__('Woocommerce','buildana'),
            'slug'               => 'woocommerce',
            'required'           => false,
        ),
        array(
            'name'               => esc_html__('Ef3 Import and Export','buildana'),
            'slug'               => 'ef3-import-and-export',
            'source'             => 'ef3-import-and-export.zip',
            'required'           => false,
        ),
        array(
            'name'               => esc_html__('Contact Form 7','buildana'),
            'slug'               => 'contact-form-7',
            'required'           => false,
        ),
        array(
            'name'               => esc_html__('Regenerate Thumbnails','buildana'),
            'slug'               => 'regenerate-thumbnails',
            'required'           => false,
        ),
        array(
            'name'               => esc_html__('Newsletter','buildana'),
            'slug'               => 'newsletter',
            'required'           => false,
        ),
        array(
            'name'               => esc_html__('YITH WooCommerce Compare','buildana'),
            'slug'               => 'yith-woocommerce-compare',
            'required'           => false,

        ),
        array(
            'name'               => esc_html__('YITH WooCommerce Wishlist','buildana'),
            'slug'               => 'yith-woocommerce-wishlist',
            'required'           => false,
        ),
    );

    /**
     * Array of configuration settings. Amend each line as needed.
     * If you want the default strings to be available under your own theme domain,
     * leave the strings uncommented.
     * Some of the strings are added into a sprintf, so see the comments at the
     * end of each line for what each argument will be.
    */
    $config = array(
        'default_path' => 'http://spyropress.com/plugins/',                      // Default absolute path to pre-packaged plugins.
    );

    tgmpa( $plugins, $config );

}