<?php

/**
 * get theme option
 */
function buildana_get_theme_option(){
    global $opt_theme_options;
    return $opt_theme_options;
}

/**
 * get meta option
 */
function buildana_get_meta_option(){
   global $opt_meta_options;
   return $opt_meta_options;
}

/**
 * get header top layout.
 */
function buildana_header_top(){
    global $opt_theme_options, $opt_meta_options;
    
    if(!class_exists('EF4Framework') || ( class_exists('EF4Framework') && empty($opt_theme_options['header_top_layout']))){ 
        get_template_part('inc/header/headertop', 'layout1');
        return;
    }
    
    if(is_page() && isset($opt_meta_options['enable_header_top']))
        $opt_theme_options['enable_header_top'] = $opt_meta_options['enable_header_top'];

    if ( isset($opt_theme_options['enable_header_top']) && $opt_theme_options['enable_header_top'] == 1 ){
        if(is_page() && !empty($opt_meta_options['header_top_layout']))
            $opt_theme_options['header_top_layout'] = $opt_meta_options['header_top_layout'];

        get_template_part('inc/header/headertop', $opt_theme_options['header_top_layout']);
    }else{
        return;
    }
}

/**
 * get header layout.
 */
function buildana_header(){
    global $opt_theme_options, $opt_meta_options;
    
    if(!class_exists('EF4Framework') || ( class_exists('EF4Framework') && empty($opt_theme_options['header_layout']))){ 
        get_template_part('inc/header/header', 'layout1');
        return;
    }
    
    if(is_page() && !empty($opt_meta_options['header_layout']))
        $opt_theme_options['header_layout'] = $opt_meta_options['header_layout'];

    get_template_part('inc/header/header', $opt_theme_options['header_layout']);
}

/**
 * get header layout class
 */
function buildana_header_layout_class($class = ''){
    global $opt_theme_options,$opt_meta_options;

    if(empty($opt_theme_options)){
        echo esc_attr($class);
        return;
    }
    
    if(is_page() && !empty($opt_meta_options['header_layout']))
        $opt_theme_options['header_layout'] = $opt_meta_options['header_layout'];

    if(!empty($opt_theme_options['header_layout']))
        $class = 'header-'.$opt_theme_options['header_layout'];

    echo esc_attr($class);
}

/**
 * get theme logo.
 */
function buildana_header_logo(){
    global $opt_theme_options, $opt_meta_options;

    $has_sticky_logo =  !empty($opt_theme_options['sticky_logo']['url']) ? 'has-sticky-logo' : '';
    echo '<div class="main_logo '.esc_attr($has_sticky_logo).'">';

    if(!empty($opt_theme_options['main_logo']['url'])) {
        echo '<a class="main-logo" href="' . esc_url(home_url('/')) . '"><img alt="' .  get_bloginfo( "name" ) . '" src="' . esc_url($opt_theme_options['main_logo']['url']) . '"></a>';

    }else {
        echo '<h3 class="site-title"><a href="' . esc_url( home_url( '/' )) . '" rel="home">' . get_bloginfo( "name" ) . '</a></h3>';
        echo '<p class="site-description">' . get_bloginfo( "description" ) . '</p>';
    }

    echo '</div>';

    buildana_header_sticky_logo();
}

/**
 * get theme logo.
 */
function buildana_header_sticky_logo(){
    global $opt_theme_options;

    /* sticky off. */
    if(!isset($opt_theme_options['menu_sticky']) || !$opt_theme_options['menu_sticky'])
        return;

    /* default logo. */
    if(empty($opt_theme_options['sticky_logo']['url']))
        return;

    echo '<div class="sticky_logo">';

    if(!empty($opt_theme_options['sticky_logo']['url'])) {
        echo '<a href="' . esc_url(home_url('/')) . '"><img alt="' .  get_bloginfo( "name" ) . '" src="' . esc_url($opt_theme_options['sticky_logo']['url']) . '"></a>';
    }else {
        echo '<h3 class="site-title"><a href="' . esc_url( home_url( '/' )) . '" rel="home">' . get_bloginfo( "name" ) . '</a></h3>';
        echo '<p class="site-description">' . get_bloginfo( "description" ) . '</p>';
    }

    echo '</div>';
}

/**
 * get header class.
 */
function buildana_header_class($class = ''){
    global $opt_theme_options;

    if(empty($opt_theme_options)){
        echo esc_attr($class);
        return;
    }

    if($opt_theme_options['menu_sticky'])
        $class .= ' sticky-desktop';

    echo esc_attr($class);
}

/**
 * main navigation.
 */
function buildana_header_navigation(){

    global $opt_meta_options;

    $attr = array(
        'menu_class' => 'nav-menu menu-main-menu',
        'theme_location' => 'primary'
    );

    if(is_page() && !empty($opt_meta_options['header_menu']))
        $attr['menu'] = $opt_meta_options['header_menu'];

    /* enable mega menu. */
    if(class_exists('HeroMenuWalker')){ $attr['walker'] = new HeroMenuWalker(); }

    $locations = get_nav_menu_locations();

    if(empty($locations[ 'primary' ]))
        return;

    /* main nav. */
    wp_nav_menu( $attr );
}

/**
 * Show main sidebar
 **/
function buildana_main_sidebar(){
    if(class_exists('Woocommerce')){
        if ( is_shop() || is_product_category() || is_product_tag() || is_product_taxonomy() || is_product() ) {
            return;
        }
    }

    if ( is_active_sidebar( 'sidebar-1' ) ){
    	echo '<div class="col-xs-12 col-sm-12 col-md-3 col-lg-3 sidebar">';
      echo '<div id="widget-area" class="widget-area">';
      dynamic_sidebar( 'sidebar-1' ); 
      echo '</div>';
      echo '</div>';
  }
} 
/**
 * Change search form
 **/
function buildana_my_search_form( $form ) {
    $form = '<form method="get" action="'. esc_url( home_url( '/'  ) ).'" class="searchform search-form">
    <div class="form-group">
    <input type="text" value="' . get_search_query() . '" name="s" class="form-control" placeholder="'.esc_html__("Search keyword",'buildana').'" id="modal-search-input">
    </div>
    <button type="submit" class="theme_button"><i class="flaticon-search"></i></button>
    ';
    $form .='</form>';
    return $form;
}
add_filter( 'get_search_form', 'buildana_my_search_form' );

/**
 * get page title layout
 */
function buildana_page_title(){
    global $opt_theme_options, $opt_meta_options;
    
    if(is_404()) return;
    /* default. */
    $layout = '1';

    /* get theme options */
    if(isset($opt_theme_options['page_title_layout']))
        $layout = $opt_theme_options['page_title_layout'];
    
    if(isset($opt_theme_options['page_title_layout']))
        $layout = $opt_theme_options['page_title_layout'];

    if(isset($opt_meta_options['disable_page_title']) && $opt_meta_options['disable_page_title']=='1'){
        return;
    }

    /* custom layout from page. */
    if(is_page() && !empty($opt_meta_options['page_title_layout']))
        $layout = $opt_meta_options['page_title_layout'];

    $align_cls = !empty($opt_theme_options['page_title_align']) ? $opt_theme_options['page_title_align'] : 'text-center';

    ?>
    <div id="page-title" class="page-title <?php echo 'layout-'.esc_attr($layout);?>">
        <div class="bg-overlay"></div>
        <div class="container">
            <div class="row">
                <?php switch ($layout){
                    case '1':
                    ?>
                    <div id="page-title-text" class="page-title-text <?php echo esc_attr($align_cls); ?> col-xs-12 col-sm-12 col-md-12 col-lg-12"><h2><?php buildana_get_page_title(); ?></h2></div>
                    <div id="breadcrumb-text" class="breadcrumb-text <?php echo esc_attr($align_cls); ?> col-xs-12 col-sm-12 col-md-12 col-lg-12"><?php buildana_get_bread_crumb(); ?></div>
                    <?php
                    break;
                    case '2':
                    ?>
                    <div id="page-title-text" class="page-title-text col-md-6 text-center text-md-left"><h2><?php buildana_get_page_title(); ?></h2></div>
                    <div id="breadcrumb-text" class="breadcrumb-text col-md-6 text-center text-md-right"><?php buildana_get_bread_crumb(); ?></div>
                    <?php
                    break;
                } ?>
            </div>
        </div>
    </div><!-- #page-title -->
    <?php
}

/**
 * page title
 */
function buildana_get_page_title(){

    global $opt_meta_options, $opt_theme_options;

    if(is_home()){
        if(is_front_page()){ 
            esc_html_e('Our Blog', 'buildana');
        } else { 
            if (!empty($opt_meta_options['page_title_text'])) {
                echo esc_html($opt_meta_options['page_title_text']);
            }else{
                echo get_the_title(get_option( 'page_for_posts' ));
            }
        }
    }
    elseif (!is_archive()){
        /* page. */
        if(is_page()) :
            /* custom title. */
            if(!empty($opt_meta_options['page_title_text'])):
                echo esc_html($opt_meta_options['page_title_text']);
            else :
                the_title();
            endif;
        elseif (is_front_page()):
            esc_html_e('Blog', 'buildana');
            /* search */
        elseif (is_search()):
            printf( esc_html__( 'Search Results for: %s', 'buildana' ), '<span>' . get_search_query() . '</span>' );
            /* 404 */
        elseif (is_404()):
            esc_html_e( '404', 'buildana');
            /* other */
        elseif (is_single() && (function_exists('is_woocommerce') && is_woocommerce() && is_product())):
            if( isset($opt_theme_options['single_shop_set_title_is_page_title']) && $opt_theme_options['single_shop_set_title_is_page_title']=='1'){
            the_title();
            }else{
                if( !empty($opt_theme_options['custom_single_shop_title']) )
                    echo esc_html($opt_theme_options['custom_single_shop_title']);
                else
                    esc_html_e( 'Single shop', 'buildana' );
            }
        elseif ( is_singular( 'project' ) ):
            if( isset($opt_theme_options['single_project_set_title_is_page_title']) && $opt_theme_options['single_project_set_title_is_page_title']=='1'){
                the_title();
            }else{
                if( !empty($opt_theme_options['custom_single_project_title']) )
                    echo esc_html($opt_theme_options['custom_single_project_title']);
                else
                    esc_html_e( 'Single project', 'buildana' );
            }
        elseif ( is_singular( 'team' ) ):
            if( isset($opt_theme_options['single_team_set_title_is_page_title']) && $opt_theme_options['single_team_set_title_is_page_title']=='1'){
                the_title();
            }else{
                if( !empty($opt_theme_options['custom_single_team_title']) )
                    echo esc_html($opt_theme_options['custom_single_team_title']);
                else
                    esc_html_e( 'Single team', 'buildana' );
            }
        elseif ( is_singular( 'services' ) ):
            if( isset($opt_theme_options['single_services_set_title_is_page_title']) && $opt_theme_options['single_services_set_title_is_page_title']=='1'){
                the_title();
            }else{
                if( !empty($opt_theme_options['custom_single_services_title']) )
                    echo esc_html($opt_theme_options['custom_single_services_title']);
                else
                    esc_html_e( 'Single service', 'buildana' );
            }
        elseif ( is_single() ):
            if( isset($opt_theme_options['single_post_set_title_is_page_title']) && $opt_theme_options['single_post_set_title_is_page_title']=='1'){
                the_title();
            }else{
                if( !empty($opt_theme_options['custom_single_post_title']) )
                    echo esc_html($opt_theme_options['custom_single_post_title']);
                else
                    esc_html_e( 'Single post', 'buildana' );
            }
        else :
            the_title();
        endif;
    } else {
        /* category. */
        if ( is_category() ) :
            single_cat_title();
        elseif ( is_tag() ) :
            /* tag. */
            single_tag_title();
            /* author. */
        elseif ( is_author() ) :
            printf( esc_html__( 'Author: %s', 'buildana' ), '<span class="vcard">' . get_the_author() . '</span>' );
            /* date */
        elseif ( is_day() ) :
            printf( esc_html__( 'Day: %s', 'buildana' ), '<span>' . get_the_date() . '</span>' );
        elseif ( is_month() ) :
            printf( esc_html__( 'Month: %s', 'buildana' ), '<span>' . get_the_date() . '</span>' );
        elseif ( is_year() ) :
            printf( esc_html__( 'Year: %s', 'buildana' ), '<span>' . get_the_date() . '</span>' );
            /* post format */
        elseif ( is_tax( 'post_format', 'post-format-aside' ) ) :
            esc_html_e( 'Asides', 'buildana' );
        elseif ( is_tax( 'post_format', 'post-format-gallery' ) ) :
            esc_html_e( 'Galleries', 'buildana');
        elseif ( is_tax( 'post_format', 'post-format-image' ) ) :
            esc_html_e( 'Images', 'buildana');
        elseif ( is_tax( 'post_format', 'post-format-video' ) ) :
            esc_html_e( 'Videos', 'buildana' );
        elseif ( is_tax( 'post_format', 'post-format-quote' ) ) :
            esc_html_e( 'Quotes', 'buildana' );
        elseif ( is_tax( 'post_format', 'post-format-link' ) ) :
            esc_html_e( 'Links', 'buildana' );
        elseif ( is_tax( 'post_format', 'post-format-status' ) ) :
            esc_html_e( 'Statuses', 'buildana' );
        elseif ( is_tax( 'post_format', 'post-format-audio' ) ) :
            esc_html_e( 'Audios', 'buildana' );
        elseif ( is_tax( 'post_format', 'post-format-chat' ) ) :
            esc_html_e( 'Chats', 'buildana' );
            /* woocommerce */
        elseif (function_exists('is_woocommerce') && is_woocommerce()):
            woocommerce_page_title();
    else :
        /* other */
        the_title();
    endif;
    }
}

/**
 * Breadcrumb NavXT
 *
 * @since 1.0.0
 */
function buildana_get_bread_crumb() {

    if(!function_exists('bcn_display')) return;

    bcn_display();
}
/**
 * Check post has thumbnail
 *
 * @since 1.0.0
 */
function buildana_get_image_crop($size) { 

    if( has_post_thumbnail() && !post_password_required() && !is_attachment() &&  wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()), $size)){
        $class = ' has-thumbnail';
        if (function_exists('wpb_getImageBySize')){
            $img_id = get_post_thumbnail_id();
            $img = wpb_getImageBySize( array(
                'attach_id'  => $img_id,
                'thumb_size' => $size,
                'class'      => '',
            ));
            $thumbnail = $img['thumbnail'];
        } else {
            $thumbnail = get_the_post_thumbnail(get_the_ID(),$size);
        }
    } 
}
/**
 * Display an optional post video.
 */
function buildana_post_video() {

    global $opt_meta_options, $wp_embed;

    /* no video. */
    if(empty($opt_meta_options['opt-video-type'])) {
        buildana_post_thumbnail();
        return;
    }

    if($opt_meta_options['opt-video-type'] == 'local' && !empty($opt_meta_options['otp-video-local']['id'])){

        $video = wp_get_attachment_metadata($opt_meta_options['otp-video-local']['id']);

        echo do_shortcode('[video width="'.esc_attr($opt_meta_options['otp-video-local']['width']).'" height="'.esc_attr($opt_meta_options['otp-video-local']['height']).'" '.$video['fileformat'].'="'.esc_url($opt_meta_options['otp-video-local']['url']).'" poster="'.esc_url($opt_meta_options['otp-video-thumb']['url']).'"][/video]');

    } elseif($opt_meta_options['opt-video-type'] == 'youtube' && !empty($opt_meta_options['opt-video-youtube'])) {

        echo do_shortcode($wp_embed->run_shortcode('[embed]'.esc_url($opt_meta_options['opt-video-youtube']).'[/embed]'));

    } elseif($opt_meta_options['opt-video-type'] == 'vimeo' && !empty($opt_meta_options['opt-video-vimeo'])) {

        echo do_shortcode($wp_embed->run_shortcode('[embed]'.esc_url($opt_meta_options['opt-video-vimeo']).'[/embed]'));

    }
}

/**
 * Display an optional post audio.
 */
function buildana_post_audio() {
    global $opt_meta_options;

    /* no audio. */
    if(empty($opt_meta_options['otp-audio']['id'])) {
        buildana_post_thumbnail();
        return;
    }

    $audio = wp_get_attachment_metadata($opt_meta_options['otp-audio']['id']);

    echo do_shortcode('[audio '.$audio['fileformat'].'="'.esc_url($opt_meta_options['otp-audio']['url']).'"][/audio]');
}

/**
 * Display an optional post gallery.
 */
function buildana_post_gallery($size='medium'){
    global $opt_theme_options, $opt_meta_options;

    /* no audio. */
    if(empty($opt_meta_options['opt-gallery'])) {
        buildana_post_thumbnail();
        return;
    }
    if(is_single()) $img_size = 'large';
    else $img_size = $size;
    $array_id = explode(",", $opt_meta_options['opt-gallery']);

    ?>
    <div class="post_gallery_wrap">
        <div id="carousel-post-gallery" class="carousel slide" data-ride="carousel">
            <div class="carousel-inner">
                <?php $i = 0; ?>
                <?php foreach ($array_id as $image_id): ?>
                    <?php
                    $attachment_image = wp_get_attachment_image_src($image_id, $img_size, false);
                    if($attachment_image[0] != ''):?>
                        <div class="item <?php if( $i == 0 ){ echo 'active'; } ?>">
                            <img style="width:100%;" data-src="holder.js" src="<?php echo esc_url($attachment_image[0]);?>"  />
                        </div>
                        <?php $i++; endif; ?>
                    <?php endforeach; ?>
                </div>
                <a class="left carousel-control" href="#carousel-post-gallery" role="button" data-slide="prev">
                    <span class="fa fa-angle-left"></span>
                </a>
                <a class="right carousel-control" href="#carousel-post-gallery" role="button" data-slide="next">
                    <span class="fa fa-angle-right"></span>
                </a>
            </div>
            <?php
            if(is_single()){
                if(isset($opt_theme_options['single_triangular']) && $opt_theme_options['single_triangular']){
                    echo '<div class="pafter">';
                    if(!isset($opt_theme_options['single_sharing_icon']) || (isset($opt_theme_options['single_sharing_icon']) && $opt_theme_options['single_sharing_icon']))
                        buildana_post_sharing();
                    echo '</div>';
                }
            }else{
                if(isset($opt_theme_options['archive_triangular']) && $opt_theme_options['archive_triangular']){
                    echo '<div class="pafter">';
                    if(!isset($opt_theme_options['archive_link_icon']) || (isset($opt_theme_options['archive_link_icon']) && $opt_theme_options['archive_link_icon']))
                        echo '<a class="bl-plink" href="'. get_the_permalink(). '" title="'. get_the_title() .'"><i class="flaticon-link"></i></a>';
                    echo '</div>';
                }
            }
            ?>
        </div>
        <?php
    }
    function buildana_post_gallery2($size='medium'){
        global $opt_theme_options, $opt_meta_options;

        /* no audio. */
        if(empty($opt_meta_options['opt-gallery'])) {
            buildana_post_thumbnail();
            return;
        }
        if(is_single()) $img_size = 'large';
        else $img_size = $size;
        $array_id = explode(",", $opt_meta_options['opt-gallery']);

        ?>
        <div class="post_gallery_wrap">
            <div id="carousel-post-gallery" class="carousel slide" data-ride="carousel">
                <div class="carousel-inner">
                    <?php $i = 0; ?>
                    <?php foreach ($array_id as $image_id): ?>
                        <?php
                        $attachment_image = wp_get_attachment_image_src($image_id, $img_size, false);
                        if($attachment_image[0] != ''):?>
                            <div class="item <?php if( $i == 0 ){ echo 'active'; } ?>">
                                <img style="width:100%;" data-src="holder.js" src="<?php echo esc_url($attachment_image[0]);?>"  />
                            </div>
                            <?php $i++; endif; ?>
                        <?php endforeach; ?>
                    </div>
                    <a class="left carousel-control" href="#carousel-post-gallery" role="button" data-slide="prev">
                        <span class="fa fa-angle-left"></span>
                    </a>
                    <a class="right carousel-control" href="#carousel-post-gallery" role="button" data-slide="next">
                        <span class="fa fa-angle-right"></span>
                    </a>
                </div>
            </div>
            <?php
        }

/**
 * Display an optional post quote.
 */
function buildana_post_quote() {
    global $opt_meta_options;

    if(empty($opt_meta_options['opt-quote-content'])){
        return;
    }

    $quote_title = !empty($opt_meta_options['opt-quote-title']) ? '<h4>'.esc_html($opt_meta_options['opt-quote-title']).'</h4>' : '' ;
    $quote_sub_title = !empty($opt_meta_options['opt-quote-sub-title']) ? '<p>'.esc_html($opt_meta_options['opt-quote-sub-title']).'</p>' : '' ;

    echo '<blockquote><p class="quote-text">'.esc_html($opt_meta_options['opt-quote-content']).'</p>'.wp_kses_post($quote_title).wp_kses_post($quote_sub_title).'</blockquote>';

}

/**
 * Display an optional post thumbnail.
 *
 * Wraps the post thumbnail in an anchor element on index
 * views, or a div element when on single views.
 */
function buildana_post_thumbnail($img_size='') {

    global $opt_theme_options;
    if ( post_password_required() || is_attachment() || ! has_post_thumbnail() ) {
        return;
    }

    $img_size = !empty($img_size) ? $img_size : 'medium';

    echo '<div class="post-thumbnail">';
    the_post_thumbnail($img_size);
    if(is_single()){
        if(isset($opt_theme_options['single_triangular']) && $opt_theme_options['single_triangular']){
            echo '<div class="pafter">';
            if(!isset($opt_theme_options['single_sharing_icon']) || (isset($opt_theme_options['single_sharing_icon']) && $opt_theme_options['single_sharing_icon']))
                buildana_post_sharing();
            echo '</div>';
        }
    }else{
        if(isset($opt_theme_options['archive_triangular']) && $opt_theme_options['archive_triangular']){
            echo '<div class="pafter">';
            if(!isset($opt_theme_options['archive_link_icon']) || (isset($opt_theme_options['archive_link_icon']) && $opt_theme_options['archive_link_icon']))
                echo '<a class="bl-plink" href="'. get_the_permalink(). '" title="'. get_the_title() .'"><i class="flaticon-link"></i></a>';
            echo '</div>';
        }
    }
    echo '</div>';
}

function buildana_post_thumbnail2($img_size='') {

    global $opt_theme_options;
    if ( post_password_required() || is_attachment() || ! has_post_thumbnail() ) {
        return;
    }

    $img_size = !empty($img_size) ? $img_size : 'medium';

    echo '<div class="post-thumbnail2">';
    echo '<a href="'. get_the_permalink(). '" title="'. get_the_title() .'">';
    the_post_thumbnail($img_size);
    echo '</a>';
    echo '</div>';
}

function buildana_getImageCroped($size){ 
    if( has_post_thumbnail() && !post_password_required() && !is_attachment() &&  wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()), $size)){
        if (function_exists('wpb_getImageBySize')){
            $img_id = get_post_thumbnail_id();
            $img = wpb_getImageBySize( array(
                'attach_id'  => $img_id,
                'thumb_size' => $size,
                'class'      => '',
            ));
            $thumbnail = $img['thumbnail'];
            //$full_src = wp_get_attachment_image_src($img_id, 'full' );
            //$thumbnail_src = $full_src[0];
        } else {
            $thumbnail = get_the_post_thumbnail(get_the_ID(),$size);
            //$full_src = wp_get_attachment_image_src(get_the_ID(), 'full' );
            //$thumbnail_src = $full_src[0];
        }
        
    }else{
        $thumbnail = '<img src="'.esc_url(get_template_directory_uri().'/assets/images/no-image.jpg').'" alt="'.get_the_title().'"/>';
    }
    return $thumbnail;
}
/**
 * Display social share in single footer.
 */
function buildana_post_sharing(){
    ?>
    <a class="bl-plink link-popup-share" href="javascript:void(0);" title="<?php echo esc_html__('Share','buildana') ?>"><i class="fa fa-share-alt"></i></a>
    <div class="entry-share">
        <a class="twitter" target="_blank" href="https://twitter.com/home?status=<?php esc_html_e('Check out this article', 'buildana');?>:%20<?php echo strip_tags(get_the_title());?>%20-%20<?php the_permalink();?>"><i aria-hidden="true" class="fa fa-twitter"></i></a>
        <a class="facebook" target="_blank" href="https://www.facebook.com/sharer/sharer.php?u=<?php the_permalink();?>"><i aria-hidden="true" class="fa fa-facebook"></i></a>
        <a class="google" target="_blank" href="https://plus.google.com/share?url=<?php the_permalink();?>"><i aria-hidden="true" class="fa fa-google-plus"></i></a>
        <a class="linkedin" title="<?php esc_html_e('Share this article to Linkedin','buildana'); ?>" target="_blank" href="https://linkedin.com/shareArticle?url=<?php the_permalink();?>"><i class="fa fa-linkedin"></i></a>
    </div>
    <?php
}

function buildana_project_sharing(){
    ?>
    <span class="lbl"><?php echo esc_html__('Social Sharing:','buildana');?></span>
    <a class="twitter" target="_blank" href="https://twitter.com/home?status=<?php esc_html_e('Check out this article', 'buildana');?>:%20<?php echo strip_tags(get_the_title());?>%20-%20<?php the_permalink();?>"><i aria-hidden="true" class="fa fa-twitter"></i></a>
    <a class="facebook" target="_blank" href="https://www.facebook.com/sharer/sharer.php?u=<?php the_permalink();?>"><i aria-hidden="true" class="fa fa-facebook"></i></a>
    <a class="google" target="_blank" href="https://plus.google.com/share?url=<?php the_permalink();?>"><i aria-hidden="true" class="fa fa-google-plus"></i></a>
    <a class="linkedin" title="<?php esc_html_e('Share this article to Linkedin','buildana'); ?>" target="_blank" href="https://linkedin.com/shareArticle?url=<?php the_permalink();?>"><i class="fa fa-linkedin"></i></a>
    <?php
}
function buildana_product_sharing(){
    ?>
    <div class="product-sharing">
        <a class="twitter" target="_blank" href="https://twitter.com/home?status=<?php esc_html_e('Check out this article', 'buildana');?>:%20<?php echo strip_tags(get_the_title());?>%20-%20<?php the_permalink();?>"><i aria-hidden="true" class="fa fa-twitter"></i></a>
        <a class="facebook" target="_blank" href="https://www.facebook.com/sharer/sharer.php?u=<?php the_permalink();?>"><i aria-hidden="true" class="fa fa-facebook"></i></a>
        <a class="google" target="_blank" href="https://plus.google.com/share?url=<?php the_permalink();?>"><i aria-hidden="true" class="fa fa-google-plus"></i></a>
        <a class="linkedin" title="<?php esc_html_e('Share this article to Linkedin','buildana'); ?>" target="_blank" href="https://linkedin.com/shareArticle?url=<?php the_permalink();?>"><i class="fa fa-linkedin"></i></a>
    </div>
    <?php
}


function buildana_post_sidebar(){
    global $opt_theme_options;

    $_sidebar = 'right';

    if(isset($opt_theme_options['single_layout']))
        $_sidebar = $opt_theme_options['single_layout'];

    if(isset($_GET['layout']) && trim($_GET['layout']) == 'full' )
        $_sidebar = 'full';
    if(isset($_GET['layout']) && trim($_GET['layout']) == 'left' )
        $_sidebar = 'left';
    if(isset($_GET['layout']) && trim($_GET['layout']) == 'right' )
        $_sidebar = 'right';
    return 'is-sidebar-' . esc_attr($_sidebar);
}

function buildana_post_class(){
    global $opt_theme_options;

    $_class = "col-xs-12 col-sm-12 col-md-9 col-lg-9";

    if(isset($opt_theme_options['single_layout']) && $opt_theme_options['single_layout'] == 'full')
        $_class = "col-xs-12 col-sm-12 col-md-10 col-md-push-1";
    if(isset($_GET['layout']) && trim($_GET['layout']) == 'full' )
        $_class = "col-xs-12 col-sm-12 col-md-10 col-md-push-1";
    

    echo esc_attr($_class);
}
/**
 * Display an optional post detail.
 */
function buildana_post_detail(){
    global $opt_theme_options;

    ?>
    <ul class="single_detail">

        <?php if(!isset($opt_theme_options['single_date']) || (isset($opt_theme_options['single_date']) && $opt_theme_options['single_date'])): ?>

        <li class="detail-date"><a href="<?php echo get_day_link(false, false, false); ?>"><?php the_date(); ?></a></li>

    <?php endif; ?>

    <?php if(!isset($opt_theme_options['single_comment']) || (isset($opt_theme_options['single_comment']) && $opt_theme_options['single_comment'])): ?>

    <li class="detail-comment"><a href="<?php the_permalink(); ?>"><?php echo esc_html(comments_number('0','1','%')); ?></a></li>

<?php endif; ?>

<?php if(has_tag() && (!isset($opt_theme_options['single_tag']) || (isset($opt_theme_options['single_tag']) && $opt_theme_options['single_tag']))): ?>

<li class="detail-tags"><span class="lbl"><?php echo esc_html__('Tags: ','buildana');?></span><?php the_tags('', ', ' ); ?></li>

<?php endif; ?>

</ul>
<?php
}


/**
 * Display single entry footer
 */
function buildana_entry_footer(){
    global $opt_theme_options;
    if( ( isset($opt_theme_options['single_footer_category']) && $opt_theme_options['single_footer_category']) || (isset($opt_theme_options['single_footer_author']) && $opt_theme_options['single_footer_author']) ){
        echo '<footer class="entry-footer">';
        if(has_category() && (!isset($opt_theme_options['single_footer_category']) || (isset($opt_theme_options['single_footer_category']) && $opt_theme_options['single_footer_category'])))
            ?>
        <span class="cat-links"><span class="lbl"><?php esc_html_e('Category: ','buildana') ?></span> <?php the_terms( get_the_ID(), 'category', '', ', ' ) ?></span>
        <?php
        if(isset($opt_theme_options['single_footer_author']) && $opt_theme_options['single_footer_author'])
            ?>
        <span class="detail-author"><span class="author-inner"><span class="author-avatar"><?php echo get_avatar(get_the_author_meta('ID'), 30); ?></span><?php echo esc_html__('Posted By','buildana'); ?> <?php the_author_posts_link(); ?></span></span>
        <?php
        echo '</footer>';
    }
}
/**
 * Display an optional archive detail.
 */
function buildana_archive_detail(){
    global $opt_theme_options;
    $archive_year  = get_the_time('Y'); 
    $archive_month = get_the_time('m'); 
    $archive_day   = get_the_time('d'); 
    ?>
    <ul class="archive_detail">

        <?php if(!isset($opt_theme_options['archive_date']) || (isset($opt_theme_options['archive_date']) && $opt_theme_options['archive_date'])): ?>
        <li class="detail-date"><a href="<?php echo get_day_link( $archive_year, $archive_month, $archive_day); ?>"><?php echo get_the_date(); ?></a></li>
    <?php endif; ?>

    <?php if(!isset($opt_theme_options['archive_comment']) || (isset($opt_theme_options['archive_comment']) && $opt_theme_options['archive_comment'])): ?>

    <li class="detail-comment"><a href="<?php the_permalink(); ?>"><?php echo esc_html(comments_number('0','1','%')); ?></a></li>

<?php endif; ?>

<?php if(!isset($opt_theme_options['archive_author']) || (isset($opt_theme_options['archive_author']) && $opt_theme_options['archive_author'])): ?>

<li class="detail-author"><?php echo esc_html__('by','buildana'); ?> <?php the_author_posts_link(); ?></li>

<?php endif; ?>

<?php if(has_category() && (!isset($opt_theme_options['archive_categories']) || (isset($opt_theme_options['archive_categories']) && $opt_theme_options['archive_categories']))): ?>

<li class="categories-links"><span class="lbl"><?php esc_html_e('Category: ','buildana') ?></span><?php the_terms( get_the_ID(), 'category', '', ', ' ); ?></li>

<?php endif; ?>

<?php if(has_tag() && (!isset($opt_theme_options['archive_tag']) || (isset($opt_theme_options['archive_tag']) && $opt_theme_options['archive_tag']))): ?>

<li class="detail-tags"><span class="lbl"><?php echo esc_html__('Tags: ','buildana');?></span><?php the_tags('', ', ' ); ?></li>

<?php endif; ?>

</ul>
<?php
}
function buildana_archive_author_detail(){
    ?>
    <div class="detail-author"><?php echo get_avatar(get_the_author_meta('ID'), 30);?><?php echo esc_html__('Posted By','buildana'); ?> <?php the_author_posts_link(); ?></div>
    <?php
}

function buildana_archive_sidebar(){
    global $opt_theme_options;

    $_sidebar = 'right';

    if(isset($opt_theme_options['archive_layout']))
        $_sidebar = $opt_theme_options['archive_layout'];

    if(isset($_GET['layout']) && trim($_GET['layout']) == 'full' )
        $_sidebar = 'full';
    if(isset($_GET['layout']) && trim($_GET['layout']) == 'left' )
        $_sidebar = 'left';
    if(isset($_GET['layout']) && trim($_GET['layout']) == 'right' )
        $_sidebar = 'right';

    return 'is-sidebar-' . esc_attr($_sidebar);
}

function buildana_archive_class(){
    global $opt_theme_options;

    $_class = "col-xs-12 col-sm-12 col-md-9 col-lg-9";

    if(isset($opt_theme_options['archive_layout']) && $opt_theme_options['archive_layout'] == 'full')
        $_class = "col-xs-12 col-sm-12 col-md-10 col-md-push-1";

    if(isset($_GET['layout']) && trim($_GET['layout']) == 'full' )
        $_class = "col-xs-12 col-sm-12 col-md-10 col-md-push-1";
    if(isset($_GET['layout']) && trim($_GET['layout']) == 'left' )
        $_class = "col-xs-12 col-sm-12 col-md-9 col-lg-9";
    if(isset($_GET['layout']) && trim($_GET['layout']) == 'right' )
        $_class = "col-xs-12 col-sm-12 col-md-9 col-lg-9";


    echo esc_attr($_class);
}

/**
 * footer layout
 */
function buildana_footer_top(){
    global $opt_theme_options;

    if(!isset($opt_theme_options))
        return;

    $_class = "";

    switch ($opt_theme_options['footer-top-column']){
        case '1':
        $_class = 'col-lg-12 col-md-12 col-sm-12 col-xs-12';
        break;
        case '2':
        $_class = 'col-lg-6 col-md-6 col-sm-6 col-xs-12';
        break;
        case '3':
        $_class = 'col-lg-4 col-md-4 col-sm-4 col-xs-12';
        break;
        case '4':
        $_class = 'col-lg-3 col-md-3 col-sm-6 col-xs-12';
        break;
    }
    for($i = 1 ; $i <= $opt_theme_options['footer-top-column'] ; $i++){
        if ( is_active_sidebar( 'sidebar-footer-top-col' . $i ) ){
            echo '<div class="' . esc_html($_class) . ' wow fadeInUp">';
            dynamic_sidebar( 'sidebar-footer-top-col' . $i );
            echo "</div>";
        }
    }

}

function buildana_footer_back_to_top(){
    global $opt_theme_options;

    $_back_to_top = true;

    if(isset($opt_theme_options['general_back_to_top']))
        $_back_to_top = $opt_theme_options['general_back_to_top'];

    if($_back_to_top)
        echo '<div class="ef3-back-to-top"><i class="fa fa-angle-up"></i></div>';
}

/**
 * Display an optional gallery gallery.
 */
function buildana_portfolio_gallery(){
    global $opt_meta_options;

    ?>
    <div class="page-wrapper post-media">
        <?php 
        if(empty($opt_meta_options['opt_port_gallery'])) {
            red_organicfood_post_thumbnail('large');   
        }else{
            $array_id = explode(",", $opt_meta_options['opt_port_gallery']);
            ?>
            <div id="carousel-port-gallery" class="carousel slide" data-ride="carousel">
                <div class="carousel-inner">
                    <?php $i = 0; ?>
                    <?php foreach ($array_id as $image_id): ?>
                        <?php
                        $attachment_image = wp_get_attachment_image_src($image_id, 'large', false);
                        if($attachment_image[0] != ''):?>
                            <div class="item <?php if( $i == 0 ){ echo 'active'; } ?>">
                                <img style="width:100%;" data-src="holder.js" src="<?php echo esc_url($attachment_image[0]);?>"  />
                            </div>
                            <?php $i++; endif; ?>
                        <?php endforeach; ?>
                    </div>

                    <a class="left carousel-control" href="#carousel-port-gallery" data-slide="prev">
                        <span class="pe-7s-angle-left"></span>
                    </a>
                    <a class="right carousel-control" href="#carousel-port-gallery" data-slide="next">
                        <span class="pe-7s-angle-right"></span>
                    </a>
                </div>
            <?php } ?> 
        </div>
        <?php
    } 
/**
 * Display team meta
 */
function buildana_team_meta(){
    global $opt_meta_options;

    ?>
    <?php if(!empty($opt_meta_options['opt_team_position'])) {?>
        <p class="position"><?php echo esc_html($opt_meta_options['opt_team_position']); ?></p>
    <?php }?>
    <?php if( !empty($opt_meta_options['opt_team_social_link_1']) || !empty($opt_meta_options['opt_team_social_link_2']) || !empty($opt_meta_options['opt_team_social_link_3']) || !empty($opt_meta_options['opt_team_social_link_4']) || !empty($opt_meta_options['opt_team_social_link_5'])) {?>
        <div class="text-center social-icons">
            <?php if( !empty($opt_meta_options['opt_team_social_link_1']) && !empty($opt_meta_options['opt_team_social_icon_class_1']) ) {?>
                <a class="social-icon soc-<?php echo esc_attr($opt_meta_options['opt_team_social_icon_class_1']);?>" href="<?php echo esc_url($opt_meta_options['opt_team_social_link_1']);?>" target="_blank" data-toggle="tooltip" data-original-title="<?php echo ucfirst(esc_attr($opt_meta_options['opt_team_social_icon_class_1']));?>"></a>
            <?php }?>
            <?php if( !empty($opt_meta_options['opt_team_social_link_2']) && !empty($opt_meta_options['opt_team_social_icon_class_2']) ) {?>
                <a class="social-icon soc-<?php echo esc_attr($opt_meta_options['opt_team_social_icon_class_2']);?>" href="<?php echo esc_url($opt_meta_options['opt_team_social_link_2']);?>" target="_blank" data-toggle="tooltip" data-original-title="<?php echo ucfirst(esc_attr($opt_meta_options['opt_team_social_icon_class_2']));?>"></a>
            <?php }?>
            <?php if( !empty($opt_meta_options['opt_team_social_link_3']) && !empty($opt_meta_options['opt_team_social_icon_class_3']) ) {?>
                <a class="social-icon soc-<?php echo esc_attr($opt_meta_options['opt_team_social_icon_class_3']);?>" href="<?php echo esc_url($opt_meta_options['opt_team_social_link_3']);?>" target="_blank" data-toggle="tooltip" data-original-title="<?php echo ucfirst(esc_attr($opt_meta_options['opt_team_social_icon_class_3']));?>"></a>
            <?php }?>
            <?php if( !empty($opt_meta_options['opt_team_social_link_4']) && !empty($opt_meta_options['opt_team_social_icon_class_4']) ) {?>
                <a class="social-icon soc-<?php echo esc_attr($opt_meta_options['opt_team_social_icon_class_4']);?>" href="<?php echo esc_url($opt_meta_options['opt_team_social_link_4']);?>" target="_blank" data-toggle="tooltip" data-original-title="<?php echo ucfirst(esc_attr($opt_meta_options['opt_team_social_icon_class_4']));?>"></a>
            <?php }?>
            <?php if( !empty($opt_meta_options['opt_team_social_link_5']) && !empty($opt_meta_options['opt_team_social_icon_class_5']) ) {?>
                <a class="social-icon soc-<?php echo esc_attr($opt_meta_options['opt_team_social_icon_class_5']);?>" href="<?php echo esc_url($opt_meta_options['opt_team_social_link_5']);?>" target="_blank" data-toggle="tooltip" data-original-title="<?php echo ucfirst(esc_attr($opt_meta_options['opt_team_social_icon_class_5']));?>"></a>
            <?php }?>
        </div>
        <?php 
    } 
} 

/**
 * Add specific CSS class by filter
 */
add_filter( 'body_class', 'buildana_body_extra_class' );
function buildana_body_extra_class( $classes ) {
    global $opt_theme_options,$opt_meta_options;
    
    if( !empty($opt_theme_options['general_layout']) && $opt_theme_options['general_layout'] == '1' ){
        $classes[] = 'boxed-layout';
    }  
    if(is_page() && isset($opt_meta_options['opt_general_layout']) && $opt_meta_options['opt_general_layout'] == '1')
        $classes[] = 'boxed-layout';

    return $classes;

}
function buildana_general_class(){
    global $opt_theme_options,$opt_meta_options;
    $classes = '';
    if( !empty($opt_theme_options['general_layout']) && $opt_theme_options['general_layout'] == '1' ){
        $classes = 'cs-boxed';
    }  
    if(is_page() && isset($opt_meta_options['opt_general_layout']) && $opt_meta_options['opt_general_layout'] == '1')
        $classes = 'cs-boxed';
    
    echo esc_attr($classes);
}  


/**
 * Team social
 */
function buildana_team_social(){
    global $opt_meta_options;
    ?>
    <?php if( !empty($opt_meta_options['opt_team_social_link_1']) || !empty($opt_meta_options['opt_team_social_link_2']) || !empty($opt_meta_options['opt_team_social_link_3']) || !empty($opt_meta_options['opt_team_social_link_4']) || !empty($opt_meta_options['opt_team_social_link_5'])) {?>
        <div class="text-center social-icons">
            <?php if( !empty($opt_meta_options['opt_team_social_link_1']) && !empty($opt_meta_options['opt_team_social_icon_class_1']) ) {?>
                <a href="<?php echo esc_url($opt_meta_options['opt_team_social_link_1']);?>" target="_blank"><i class="<?php echo esc_attr($opt_meta_options['opt_team_social_icon_class_1']); ?>"></i></a>
            <?php }?>
            <?php if( !empty($opt_meta_options['opt_team_social_link_2']) && !empty($opt_meta_options['opt_team_social_icon_class_2']) ) {?>
                <a href="<?php echo esc_url($opt_meta_options['opt_team_social_link_2']);?>" target="_blank"><i class="<?php echo esc_attr($opt_meta_options['opt_team_social_icon_class_2']); ?>"></i></a>
            <?php }?>
            <?php if( !empty($opt_meta_options['opt_team_social_link_3']) && !empty($opt_meta_options['opt_team_social_icon_class_3']) ) {?>
                <a href="<?php echo esc_url($opt_meta_options['opt_team_social_link_3']);?>" target="_blank"><i class="<?php echo esc_attr($opt_meta_options['opt_team_social_icon_class_3']); ?>"></i></a>
            <?php }?>
            <?php if( !empty($opt_meta_options['opt_team_social_link_4']) && !empty($opt_meta_options['opt_team_social_icon_class_4']) ) {?>
                <a href="<?php echo esc_url($opt_meta_options['opt_team_social_link_4']);?>" target="_blank"><i class="<?php echo esc_attr($opt_meta_options['opt_team_social_icon_class_4']); ?>"></i></a>
            <?php }?>
            <?php if( !empty($opt_meta_options['opt_team_social_link_5']) && !empty($opt_meta_options['opt_team_social_icon_class_5']) ) {?>
                <a href="<?php echo esc_url($opt_meta_options['opt_team_social_link_5']);?>" target="_blank"><i class="<?php echo esc_attr($opt_meta_options['opt_team_social_icon_class_5']); ?>"></i></a>
            <?php }?>
        </div>
        <?php 
    } 
}

/**
 * Enable Footer newsletter 
 */
function buildana_get_newsletter_enable(){
    global $opt_theme_options,$opt_meta_options;
    if(is_page() && isset($opt_meta_options['footer_enable_newsletter']))
        $opt_theme_options['footer_enable_newsletter'] = $opt_meta_options['footer_enable_newsletter'];
    if( isset($opt_theme_options['footer_enable_newsletter']) && $opt_theme_options['footer_enable_newsletter']){
        return true;
    }
    return false;
}

/**
 * Footer newsletter is boxed
 */
function buildana_get_newsletter_boxed(){
    global $opt_theme_options,$opt_meta_options;
    if(is_page() && isset($opt_meta_options['newsletter_boxed']) && $opt_meta_options['newsletter_boxed'])
        $opt_theme_options['newsletter_boxed'] = $opt_meta_options['newsletter_boxed'];
    if( isset($opt_theme_options['newsletter_boxed']) && $opt_theme_options['newsletter_boxed']){
        return true;
    }
    return false;
}

/**
 * Change number product to show
 */
add_action('after_setup_theme','buildana_update_woo_number_item_in_page');
function buildana_update_woo_number_item_in_page(){
    if(class_exists('EF4Framework')){
        if(class_exists( 'Woocommerce' )){
            add_filter( 'loop_shop_per_page', 'buildana_woocommerce_number_columms' );
        }
    }
}
/*
* Woocomerce shop columms number
*/
function buildana_woocommerce_number_columms(){
    global $opt_theme_options;
    $number_product = ( !empty($opt_theme_options['shop_products']) ) ? $opt_theme_options['shop_products'] : 8; 
    return $number_product;
}
/*
*Change title in single page for posts
*/
add_action('wp_head','buildana_maybe_fix_opt_meta_options',1);
function buildana_maybe_fix_opt_meta_options()
{
    global $opt_meta_options;
    if(!is_array($opt_meta_options))
        $opt_meta_options = [];
    if(function_exists('wc_get_page_id') && is_archive() && is_post_type_archive('product') && is_numeric($id = wc_get_page_id('shop')))
        $real_page = get_post($id);
    else
        $real_page =  get_queried_object();
    if($real_page instanceof WP_Post)
    {
        $id = $real_page->ID;
        if($id == get_the_ID())
            return;
        $post_metas = get_post_meta($id);
        $opt_meta_options = [];
        $prefix_option = 'ef3-';
        foreach ($post_metas  as $key => $value) {
            if(strpos($key,$prefix_option) === 0)
            {
                $opt_meta_options[substr($key,strlen($prefix_option))] = maybe_unserialize( $value[0] );
            }
        }
    }
}
/*
*  Title post in single and single post type!
*/
function buildana_maybe_move_title_to_header_title($post_type){
    global $opt_theme_options;
    if ($post_type == 'post' & empty($opt_theme_options['single_post_set_title_is_page_title'])):
        the_title( '<h4 class="entry-title">', '</h4>' );   
    elseif ($post_type == 'team' & empty($opt_theme_options['single_team_set_title_is_page_title'])):
        the_title( '<h5 class="entry-title">', '</h5>' );
    endif;
}