<?php 
if (!function_exists('register_ef4_widget')) return;
function buildana_register_widget_business_hour(){
    register_ef4_widget( 'Cms_Business_Hours_Widget' );
}
add_action( 'widgets_init', 'buildana_register_widget_business_hour' );

class Cms_Business_Hours_Widget extends WP_Widget {
    /**
     * Constructor
     *
     * @return void
     **/
    function __construct() {
        parent::__construct(
            'cms_business_hours', // Base ID
            esc_html__( 'Cms Business Hours', 'buildana' ), // Name
            array(
                'description' => esc_html__( 'Add business hours box.', 'buildana' ),
                'customize_selective_refresh' => true
            ) // Args
        );
     
    }
 
    /**
     * Outputs the HTML for this widget.
     *
     * @param array  An array of standard parameters for widgets in this theme
     * @param array  An array of settings for this widget instance
     * @return void Echoes it's output
     **/
    function widget( $args, $instance )
    {
        extract( $args, EXTR_SKIP );
        
        $instance = wp_parse_args(
            (array) $instance,
            array(
                'title' => '',
                'text_content' => '',
                'mon_to_fri' => '',
                'saturday'  => '',
                'sunday' => '',
            )
        );

        if ( ! empty( $instance['title'] ) ) {
            $title = apply_filters( 'widget_title', $instance['title'], $instance, $this->id_base );
        }
        else {
            $title = '';
        }

        echo wp_kses_post($before_widget);

        if ( ! empty( $title ) )
        {
            echo wp_kses_post($before_title . $title . $after_title);
        }
        
        echo '<div class="business-hours-widget">'; 
        if ( ! empty( $instance['text_content'] )){ 
            echo '<p class="text_content">'.esc_html($instance['text_content']).'</p>';
        }
        if ( ! empty( $instance['mon_to_fri'] )){ 
            echo '<p><span class="lbl">'.esc_html__('Monday-Friday: ','buildana').'</span>'.esc_html($instance['mon_to_fri']).'</p>';
        }
        if ( ! empty( $instance['saturday'] )){ 
            echo '<p><span class="lbl">'.esc_html__('Saturday: ','buildana').'</span>'.esc_html($instance['saturday']).'</p>';
        }
        if ( ! empty( $instance['sunday'] )){ 
            echo '<p><span class="lbl">'.esc_html__('Sunday: ','buildana').'</span>'.esc_html($instance['sunday']).'</p>';
        }
        echo '</div>';
        

        echo wp_kses_post($after_widget);
    }

    /**
     * Deals with the settings when they are saved by the admin. Here is
     * where any validation should be dealt with.
     *
     * @param array  An array of new settings as submitted by the admin
     * @param array  An array of the previous settings
     * @return array The validated and (if necessary) amended settings
     **/
    function update( $new_instance, $old_instance )
    {
        $instance = $old_instance;
         
        $instance['title'] = sanitize_text_field( $new_instance['title'] );
        $instance['text_content'] = sanitize_text_field( $new_instance['text_content'] );
        $instance['mon_to_fri'] = sanitize_text_field( $new_instance['mon_to_fri'] );
        $instance['saturday'] = sanitize_text_field( $new_instance['saturday'] );
        $instance['sunday'] = sanitize_text_field( $new_instance['sunday'] );
        
        return $instance;
    }

    /**
     * Displays the form for this widget on the Widgets page of the WP Admin area.
     *
     * @param array  An array of the current settings for this widget
     * @return void Echoes it's output
     **/
    function form( $instance )
    {
        $instance = wp_parse_args(
            (array) $instance,
            array(
                'title' => '',
                'text_content' => '',
                'mon_to_fri' => '',
                'saturday' => '',
                'sunday' => '',
            )
        );

        $this_id    = $this->get_field_id( '' );
        $title      = isset( $instance['title'] ) ? esc_attr( $instance['title'] ) : '';
        
        ?>
        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"><?php esc_html_e( 'Title:', 'buildana' ); ?></label>
            <input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
        </p>
        
        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'text_content' ) ); ?>"><?php esc_html_e( 'Content Text:', 'buildana' ); ?></label>
            <textarea class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'text_content' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'text_content' ) ); ?>" rows="3"><?php echo esc_attr( $instance['text_content'] ); ?></textarea>
            
        </p>
          
        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'mon_to_fri' ) ); ?>"><?php esc_html_e( 'monday to friday:', 'buildana' ); ?></label>
            <input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'mon_to_fri' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'mon_to_fri' ) ); ?>" type="text" value="<?php echo esc_attr( $instance['mon_to_fri'] ); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'saturday' ) ); ?>"><?php esc_html_e( 'Saturday:', 'buildana' ); ?></label>
            <input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'saturday' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'saturday' ) ); ?>" type="text" value="<?php echo esc_attr( $instance['saturday'] ); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'sunday' ) ); ?>"><?php esc_html_e( 'Sunday:', 'buildana' ); ?></label>
            <input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'sunday' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'sunday' ) ); ?>" type="text" value="<?php echo esc_attr( $instance['sunday'] ); ?>" />
        </p>
        
        <?php
    }
}
 