<?php
/**
 * Cms Certificates Widget
 * This widget allows you to pick multiple images and show at the front-end with some options
 */
if (!function_exists('register_ef4_widget')) return;
function buildana_register_widget_certificates(){
    register_ef4_widget( 'Cms_Certificates_Widget' );
}
add_action( 'widgets_init', 'buildana_register_widget_certificates' );

class Cms_Certificates_Widget extends WP_Widget
{
    /**
     * Constructor
     *
     * @return void
     **/
    function __construct()
    {
        parent::__construct(
            'cms_certificates', // Base ID
            esc_html__( 'Cms Certificates', 'buildana' ), // Name
            array(
                'description' => esc_html__( 'Add multiple images with some options and optional links.', 'buildana' ),
                'customize_selective_refresh' => true
            ) // Args
        );
         
    }
     
    
    /**
     * Outputs the HTML for this widget.
     *
     * @param array $args An array of standard parameters for widgets in this theme
     * @param array $instance An array of settings for this widget instance
     * @return void Echoes it's output
     **/
    function widget( $args, $instance )
    {
        extract( $args, EXTR_SKIP );
        $instance = wp_parse_args(
            (array) $instance,
            array(
                'title' => '',
                'images' => '',
                'names'  => '',
                'experiences' => '',
                'links' => '',
                'size' => 'thumbnail'
            )
        );
 
        if ( ! empty( $instance['title'] ) )
        {
            $title = apply_filters( 'widget_title', $instance['title'], $instance, $this->id_base );
        }
          
        echo wp_kses_post($before_widget);

        if ( ! empty( $title ) )
        {
            echo wp_kses_post($before_title . $title . $after_title);
        }

        $images = $links = array();

        if ( ! empty( $instance['images'] ) )
        {
            $images = explode( ",", $instance['images'] );
        }
        if ( ! empty( $instance['names'] ) )
        {
            $names = explode( "|", $instance['names'] );
        }
        if ( ! empty( $instance['experiences'] ) )
        {
            $experiences = explode( "|", $instance['experiences'] );
        }
        if ( ! empty( $instance['links'] ) )
        {
            $links = explode( "|", $instance['links'] );
        }

        if ( ! empty( $images ) )
        {
            echo '<div class="certificate-list">';

            for ( $i = 0; $i < count( $images ) ; $i++ )
            {
                echo '<div class="cer-item">';
                    if ( isset( $images[$i] ) && ! empty( $images[$i] ) ){
                        echo '<div class="entry-thumbnail">';
                        echo wp_get_attachment_image( $images[$i], 'thumbnail' );
                        echo '</div>';
                    }
                    echo '<div class="entry-main">';
                        if ( isset( $names[$i] ) && ! empty( $names[$i] ) ){
                            echo '<h6 class="cer-name">';
                            if ( isset( $links[$i] ) && ! empty( $links[$i] ) )
                            {    
                                echo '<a href="' . esc_url( $links[$i] ) . '">';
                                echo esc_html($names[$i]);
                                echo '</a>';
                            }else{
                                echo esc_html($names[$i]);
                            }
                            echo '</h6>';
                        }
                        if ( isset( $experiences[$i] ) && ! empty( $experiences[$i] ) ){
                            echo '<span class="experence">'.esc_html($experiences[$i]).'</span>';
                        }
                    echo '</div>';
                echo '</div>';
            }
            echo '</div>';
        }

        echo wp_kses_post($after_widget);
    }

    /**
     * Deals with the settings when they are saved by the admin. Here is
     * where any validation should be dealt with.
     *
     * @param array $new_instance An array of new settings as submitted by the admin
     * @param array $old_instance An array of the previous settings
     * @return array The validated and (if necessary) amended settings
     **/
    function update( $new_instance, $old_instance )
    {

        $instance = $old_instance;
        $instance['title'] = sanitize_text_field( $new_instance['title'] );
        $instance['images'] = sanitize_text_field( $new_instance['images'] );
          
        $names = array();
        $names_arr = explode( "\n", $new_instance['names'] );
        foreach ( $names_arr as $name)
        {
            $name = trim( $name );
            if ( empty( $name ) )
                continue;
            $names[] = $name;
        }
        $instance['names'] = implode( "|", $names );
        
        $experiences = array();
        $experiences_arr = explode( "\n", $new_instance['experiences'] );
        foreach ( $experiences_arr as $experience)
        {
            $experience = trim( $experience );
            if ( empty( $experience ) )
                continue;
            $experiences[] = $experience;
        }
        $instance['experiences'] = implode( "|", $experiences );
        
        
        $links = array();
        $links_arr = explode( "\n", $new_instance['links'] );
        foreach ( $links_arr as $link )
        {
            $link = trim( $link );
            if ( empty( $link ) )
                continue;
            $links[] = esc_url( $link );
        }

        $instance['links'] = implode( "|", $links );
          
        return $instance;
    }
     
    /**
     * Displays the form for this widget on the Widgets page of the WP Admin area.
     *
     * @param array  An array of the current settings for this widget
     * @return void Echoes it's output
     **/
    function form( $instance )
    {
        $instance = wp_parse_args(
            (array) $instance,
            array(
                'title' => '',
                'images' => '',
                'names' => '',
                'experiences' => '',
                'links' => '',
            )
        );

        $image_holder = $this->get_field_id( 'images' ) . '-' . buildana_generate_uiqueid();
        $title      = isset( $instance['title'] ) ? esc_attr( $instance['title'] ) : '';
        $image_ids  = explode( ",", $instance['images'] );
        $names      = explode( "|", $instance['names'] );
        $experiences = explode( "|", $instance['experiences'] );
        $links      = explode( "|", $instance['links'] );
     
        ?>
        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"><?php esc_html_e( 'Title:', 'buildana' ); ?></label>
            <input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
        </p>
         
        <div class="redexp-widget-image">
            <input type="hidden" name="<?php echo esc_attr($this->get_field_name( 'images' )); ?>" id="<?php echo esc_attr($this->get_field_id( 'images' )); ?>" value="<?php echo esc_attr( $instance['images'] ); ?>"/>
            <label><?php esc_html_e( 'Images', 'buildana' ); ?></label>
            <ul class="redexp-mu-images" id="<?php echo esc_attr( $image_holder ); ?>" data-img-mu-field="<?php echo esc_attr($this->get_field_id( 'images' )); ?>"><?php
            foreach ( $image_ids as $image )
            {
                $attachment_image = wp_get_attachment_image_src( $image, 'thumbnail' );
                if ( ! empty( $attachment_image ) )
                {
                    printf(
                        '<li data-id="%1$s" style="background-image:url(%2$s);">',
                        esc_attr( $image ),
                        esc_url( $attachment_image[0] )
                    );

                    printf(
                        '<a class="image-edit" href="#" onclick="RedExpMedia.Images.edit(event,%s);"><i class="dashicons dashicons-edit"></i></a>',
                        esc_attr( '"' . $image_holder . '"' )
                    );

                    printf(
                        '<a class="image-delete" href="#" onclick="RedExpMedia.Images.remove(event,%s);"><i class="dashicons dashicons-trash"></i></a>',
                        esc_attr( '"' . $image_holder . '"' )
                    );

                    echo '</li>';
                }
            }
            printf(
                '<li data-id="0"><a class="image-add" href="#" onclick="RedExpMedia.Images.add(event,%s);"><i class="dashicons dashicons-plus-alt"></i></a></li>',
                esc_attr( '"' . $image_holder . '"' )
            );
            ?></ul>
            
        </div>
         
        <label for="<?php echo esc_attr( $this->get_field_id( 'names' ) ); ?>"><?php echo esc_html__( 'Names', 'buildana' ); ?></label>
        <textarea class="image-names widefat" id="<?php echo esc_attr( $this->get_field_id( 'names' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'names' ) ); ?>" rows="10"><?php
            foreach ( $names as $name ) {
                if ( empty( $name ) ) {
                    continue;
                }
                echo esc_textarea($name);
                echo "\n";
            }
        ?></textarea>
        <p class="howto"><?php echo esc_html__( 'Add name for images, seperate by newline.', 'buildana' ); ?></p>
        
        <label for="<?php echo esc_attr( $this->get_field_id( 'experiences' ) ); ?>"><?php echo esc_html__( 'Experiences', 'buildana' ); ?></label>
        <textarea class="image-names widefat" id="<?php echo esc_attr( $this->get_field_id( 'experiences' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'experiences' ) ); ?>" rows="10"><?php
            foreach ( $experiences as $experience ) {
                if ( empty( $experience ) ) {
                    continue;
                }
                echo esc_textarea($experience);
                echo "\n";
            }
        ?></textarea>
        <p class="howto"><?php echo esc_html__( 'Add experience for images, seperate by newline.', 'buildana' ); ?></p>
        
        <label for="<?php echo esc_attr( $this->get_field_id( 'links' ) ); ?>"><?php echo esc_html__( 'Links', 'buildana' ); ?></label>
        <textarea class="image-links widefat" id="<?php echo esc_attr( $this->get_field_id( 'links' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'links' ) ); ?>" rows="10"><?php
            foreach ( $links as $link ) {
                if ( empty( $link ) ) {
                    continue;
                }
                echo esc_url( $link );
                echo "\n";
            }
        ?></textarea>
        <p class="howto"><?php echo esc_html__( 'Add links for images, seperate by newline.', 'buildana' ); ?></p>
         
        <?php
    }
}
