<?php
/**
 * Cms Galelry Image Widget
 * This widget allows you to pick multiple images and show at the front-end with some options
 */
if (!function_exists('register_ef4_widget')) return;
function buildana_register_widget_gallery_images(){
    register_ef4_widget( 'Cms_Gallery_Images_Widget' );
}
add_action( 'widgets_init', 'buildana_register_widget_gallery_images' );

class Cms_Gallery_Images_Widget extends WP_Widget
{
    /**
     * Constructor
     *
     * @return void
     **/
    function __construct()
    {
        parent::__construct(
            'cms_gallery_images', // Base ID
            esc_html__( 'Cms Gallery Images', 'buildana' ), // Name
            array(
                'description' => esc_html__( 'Add multiple images with some options and optional links.', 'buildana' ),
                'customize_selective_refresh' => true
            ) // Args
        );
         
    }
     
    
    /**
     * Outputs the HTML for this widget.
     *
     * @param array $args An array of standard parameters for widgets in this theme
     * @param array $instance An array of settings for this widget instance
     * @return void Echoes it's output
     **/
    function widget( $args, $instance )
    {
        extract( $args, EXTR_SKIP );
        $instance = wp_parse_args(
            (array) $instance,
            array(
                'title' => '',
                'images' => '',
            )
        );
        if ( ! empty( $instance['title'] ) )
        {
            $title = apply_filters( 'widget_title', $instance['title'], $instance, $this->id_base );
        }
        echo wp_kses_post($before_widget);

        if ( ! empty( $title ) )
        {
            echo wp_kses_post($before_title . $title . $after_title);
        }

        $images = array();

        if ( ! empty( $instance['images'] ) )
        {
            $images = explode( ",", $instance['images'] );
        }
         
        if ( ! empty( $images ) )
        {
            echo '<ul class="images cms-gallerys">';

            for ( $i = 0; $i < count( $images ) ; $i++ )
            {
                if ( isset( $images[$i] ) && ! empty( $images[$i] ) )
                {
                    $image_srcs = wp_get_attachment_image_src( $images[$i], 'full' );
                    $img_src = $image_srcs[0];
                    echo '<li>';
                    echo '<a class="magic-popups" href="' . esc_url( $img_src ) . '">';
                        echo wp_get_attachment_image( $images[$i], 'buildana-540-430' );
                    echo '</a>';
                    echo '</li>';
                }
            }
            echo '</ul>';
        }

        echo wp_kses_post($after_widget);
    }

    /**
     * Deals with the settings when they are saved by the admin. Here is
     * where any validation should be dealt with.
     *
     * @param array $new_instance An array of new settings as submitted by the admin
     * @param array $old_instance An array of the previous settings
     * @return array The validated and (if necessary) amended settings
     **/
    function update( $new_instance, $old_instance )
    {

        $instance = $old_instance;
        $instance['title'] = sanitize_text_field( $new_instance['title'] );
        $instance['images'] = sanitize_text_field( $new_instance['images'] );
 
        return $instance;
    }
     
    /**
     * Displays the form for this widget on the Widgets page of the WP Admin area.
     *
     * @param array  An array of the current settings for this widget
     * @return void Echoes it's output
     **/
    function form( $instance )
    {
        $instance = wp_parse_args(
            (array) $instance,
            array(
                'title' => '',
                'images' => '',
            )
        );

        $image_holder = $this->get_field_id( 'images' ) . '-' . buildana_generate_uiqueid();
        $title      = isset( $instance['title'] ) ? esc_attr( $instance['title'] ) : '';
        $image_ids  = explode( ",", $instance['images'] );
        ?>
        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"><?php esc_html_e( 'Title:', 'buildana' ); ?></label>
            <input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
        </p>
        <div class="payment-logo-widget-image">
            <input type="hidden" name="<?php echo esc_attr( $this->get_field_name( 'images' )); ?>" id="<?php echo esc_attr($this->get_field_id( 'images')); ?>" value="<?php echo esc_attr( $instance['images'] ); ?>"/>
            <label><?php esc_html_e( 'Images', 'buildana' ); ?></label>
            <ul class="redexp-mu-images" id="<?php echo esc_attr( $image_holder ); ?>" data-img-mu-field="<?php echo esc_attr($this->get_field_id( 'images' )); ?>"><?php
            foreach ( $image_ids as $image )
            {
                $attachment_image = wp_get_attachment_image_src( $image, 'thumbnail' );
                if ( ! empty( $attachment_image ) )
                {
                    printf(
                        '<li data-id="%1$s" style="background-image:url(%2$s);">',
                        esc_attr( $image ),
                        esc_url( $attachment_image[0] )
                    );

                    printf(
                        '<a class="image-edit" href="#" onclick="RedExpMedia.Images.edit(event,%s);"><i class="dashicons dashicons-edit"></i></a>',
                        esc_attr( '"' . $image_holder . '"' )
                    );

                    printf(
                        '<a class="image-delete" href="#" onclick="RedExpMedia.Images.remove(event,%s);"><i class="dashicons dashicons-trash"></i></a>',
                        esc_attr( '"' . $image_holder . '"' )
                    );

                    echo '</li>';
                }
            }
            printf(
                '<li data-id="0"><a class="image-add" href="#" onclick="RedExpMedia.Images.add(event,%s);"><i class="dashicons dashicons-plus-alt"></i></a></li>',
                esc_attr( '"' . $image_holder . '"' )
            );
            ?></ul>
        </div>
        <?php
    }
}
