<?php
/**
 * The Template for displaying all single services
 *
 * @package CMSSuperHeroes
 * @subpackage CMS Theme
 * @since 1.0.0
 */

get_header(); ?>
<div id="primary" class="container">
    <div class="row row-services">
        <div class="col-xs-12 col-sm-12 col-md-12 col-lg-10 col-lg-offset-1">
            <main id="main" class="site-main">
                <?php while ( have_posts() ) : the_post(); 
                $service_category = get_the_terms( get_the_ID(), 'services_category', '', ', ' );
                if(has_post_thumbnail() && !post_password_required() && !is_attachment() &&  wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()), 'full', false)):
                    $class = ' has-thumbnail';
                    $thumbnail = get_the_post_thumbnail(get_the_ID(),'medium');
                else:
                    $class = ' no-image';
                    $thumbnail = '<img src="'.esc_url(get_template_directory_uri().'/assets/images/no-image.jpg').'" alt="'.get_the_title().'"/>';
                endif;
                $meta_options = buildana_get_meta_option();
                $icon_img = !empty($meta_options['service_icon_image']['url']) ? $meta_options['service_icon_image']['url'] : '';
                $service_intro_text = !empty($meta_options['service_intro_text']) ? $meta_options['service_intro_text'] : '';
                $service_work_hour = !empty($meta_options['service_work_hour']) ? $meta_options['service_work_hour'] : '';
                $service_email = !empty($meta_options['service_email']) ? $meta_options['service_email'] : '';
                $service_phone = !empty($meta_options['service_phone']) ? $meta_options['service_phone'] : '';
                ?>
                    <article id="post-<?php the_ID(); ?>" <?php post_class('buildana-service-single'); ?>>
                        <div class="row">
                            <div class="col-xs-12 col-sm-12 col-md-6">
                                <div class="post-service-thumbnail">
                                    <?php echo buildana_html($thumbnail);?> 
                                    <div class="pafter"></div>
                                </div>
                            </div>
                            <div class="col-xs-12 col-sm-12 col-md-6">
                                <div class="meta-content">
                                    <?php if(!empty($icon_img)):?>
                            			<img class="ico-img" src="<?php echo esc_url($icon_img);?>" />
                                    <?php endif;?>
                                    
                                    <?php if($service_category):?>
                                        <div class="cats">
                                        <?php the_terms( get_the_ID(), 'services_category', '', ', ' ); ?>
                                        </div>
                                    <?php endif;?>
                                    
                                    <?php the_title( '<h5 class="entry-title">', '</h5>' ); ?>
                                    
                                    <?php if(!empty($service_intro_text)):?>
                        				<p class="intro-text"><?php echo esc_html($service_intro_text);?></p>
                                    <?php endif;?>
                                    <?php if(!empty($service_work_hour)):?>
                        				<p class="service-meta"><?php echo esc_html($service_work_hour);?></p>
                                    <?php endif;?>
                                    <?php if(!empty($service_email)):?>
                        				<p class="service-meta"><?php echo esc_html($service_email);?></p>
                                    <?php endif;?>
                                    <?php if(!empty($service_phone)):?>
                        				<p class="service-meta"><?php echo esc_html($service_phone);?></p>
                                    <?php endif;?>
                                </div>
                            </div>
                        </div>               
                    	
                        <div class="service-entry-wrap">
                        	<div class="entry-content"><?php the_content(); ?> </div> 
                        </div>
                    </article> 
                <?php endwhile; ?>
            </main> 
        </div>
    </div>
</div><!-- #primary -->
<?php get_footer(); ?>