<?php
/**
 * The Template for displaying all single team
 *
 * @package CMSSuperHeroes
 * @subpackage CMS Theme
 * @since 1.0.0
 */

get_header(); ?>
<div id="primary" class="container ">
    <div class="row-team">
        <?php while ( have_posts() ) : the_post(); 
         
        if(has_post_thumbnail() && !post_password_required() && !is_attachment() &&  wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()), 'full', false)):
            $class = ' has-thumbnail';
            $thumbnail = get_the_post_thumbnail(get_the_ID(),'medium');
        else:
            $class = ' no-image';
            $thumbnail = '<img src="'.esc_url(get_template_directory_uri().'/assets/images/no-image.jpg').'" alt="'.get_the_title().'"/>';
        endif;
        $meta_options = buildana_get_meta_option();
        $icon_img = !empty($meta_options['service_icon_image']['url']) ? $meta_options['service_icon_image']['url'] : '';
        $service_intro_text = !empty($meta_options['service_intro_text']) ? $meta_options['service_intro_text'] : '';
        $service_work_hour = !empty($meta_options['service_work_hour']) ? $meta_options['service_work_hour'] : '';
        $service_email = !empty($meta_options['service_email']) ? $meta_options['service_email'] : '';
        $service_phone = !empty($meta_options['service_phone']) ? $meta_options['service_phone'] : '';
        ?>
            <article id="post-<?php the_ID(); ?>" <?php post_class('buildana-team-single'); ?>>
                <div class="row">
                    <div class="col-xs-12 col-sm-12 col-md-12 col-lg-10 col-lg-offset-1">
                        <div class="row top-content">
                            <div class="col-xs-12 col-sm-12 col-md-5">
                                <div class="post-team-thumbnail">
                                    <?php echo buildana_html($thumbnail);?> 
                                    <div class="pafter"></div>
                                    <?php buildana_team_social();?>
                                </div>
                            </div>
                            <div class="col-xs-12 col-sm-12 col-md-7">
                                <div class="meta-content">
                                    <?php buildana_maybe_move_title_to_header_title('team') ?>
                                    <?php if(!empty($meta_options['opt_team_position'])):?>
                            			<span class="lbl"><?php echo esc_html($meta_options['opt_team_position']);?></span>
                                    <?php endif;?>
                                    <?php if(!empty($meta_options['opt_team_intro_text'])):?>
                        				<p class="intro-text"><?php echo esc_html($meta_options['opt_team_intro_text']);?></p>
                                    <?php endif;?>
                                    <?php if(!empty($meta_options['opt_team_dob'])):?>
                        				<p class="team-meta"><span class="lbl"><?php echo esc_html__('Date of birth: ','buildana'); ?></span><?php echo esc_html($meta_options['opt_team_dob']);?></p>
                                    <?php endif;?>
                                    <?php if(!empty($meta_options['opt_team_email'])):?>
                        				<p class="team-meta"><span class="lbl"><?php echo esc_html__('Email Address: ','buildana'); ?></span><?php echo esc_html($meta_options['opt_team_email']);?></p>
                                    <?php endif;?>
                                    <?php if(!empty($meta_options['opt_team_phone'])):?>
                        				<p class="team-meta"><span class="lbl"><?php echo esc_html__('Phone No: ','buildana'); ?></span><?php echo esc_html($meta_options['opt_team_phone']);?></p>
                                    <?php endif;?>
                                    <?php if(!empty($meta_options['opt_team_address'])):?>
                        				<p class="team-meta"><span class="lbl"><?php echo esc_html__('Address: ','buildana'); ?></span><?php echo esc_html($meta_options['opt_team_address']);?></p>
                                    <?php endif;?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>               
            	 
                <div class="entry-content"><?php the_content(); ?> </div> 
                 
            </article> 
        <?php endwhile; ?>
    </div>      
</div> 
<?php get_footer(); ?>