<?php
/**
 * The template used for displaying page content in page.php
 *
 * @package CMSSuperHeroes
 * @subpackage CMS Theme
 * @since 1.0.0
 */
?>
<?php 
$theme_options = buildana_get_theme_option(); 
$project_category = get_the_terms( get_the_ID(), 'project_category', '', ', ' );
$meta_options = buildana_get_meta_option();
?>    
<article id="post-<?php the_ID(); ?>" <?php post_class('project-style style2'); ?>>
    <?php
    if(has_post_thumbnail() && !post_password_required() && !is_attachment() &&  wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()), 'full', false)):
        $thumbnail = get_the_post_thumbnail(get_the_ID(),'buildana-970-460');
    ?>
    <div class="single-project-thumbnail">
        <?php echo wp_kses_post($thumbnail); ?>
        <div class="pafter"></div>
        <?php if( !empty($meta_options['project_client']) || !empty($meta_options['project_location']) || !empty($meta_options['project_started']) || !empty($meta_options['project_completed']) ):?>
            <ul class="project-meta">
                <?php if( !empty($meta_options['project_client'])): ?><li><span class="plbl"><?php echo esc_html__('Client: ','buildana');?></span><?php echo esc_html($meta_options['project_client']);?></li><?php endif;?>
                <?php if( !empty($meta_options['project_location'])): ?><li><span class="plbl"><?php echo esc_html__('Location: ','buildana');?></span><?php echo esc_html($meta_options['project_location']);?></li><?php endif;?>
                <?php if( !empty($meta_options['project_started'])): ?><li><span class="plbl"><?php echo esc_html__('Started: ','buildana');?></span><?php echo esc_html($meta_options['project_started']);?></li><?php endif;?>
                <?php if( !empty($meta_options['project_completed'])): ?><li><span class="plbl"><?php echo esc_html__('Completed: ','buildana');?></span><?php echo esc_html($meta_options['project_completed']);?></li><?php endif;?>
            </ul>
        <?php endif;?>
    </div>
    <?php endif;?>
    <div class="entry-wrap">
        <div class="entry-header">
            <?php if($project_category):?>
                <div class="cats">
                <?php the_terms( get_the_ID(), 'project_category', '', ', ' ); ?>
                </div>
            <?php endif;?>
            <?php the_title( '<h5 class="entry-title">', '</h5>' ); ?>
        </div>
    	<div class="entry-content">
    			<?php the_content(); ?>
    	</div>
        <div class="project-sharing entry-footer">
        <div class="soc-left">
            <?php buildana_project_sharing(); ?>
        </div>
        <?php buildana_project_nav(); ?>
        </div>
    </div>
     
</article><!-- #post -->
