<?php
/**
 * The default template for displaying content
 *
 * Used for both single and index/archive/search.
 *
 * @package WordPress
 * @since 1.0.0
 */
?>

<article id="post-<?php the_ID(); ?>" <?php post_class('buildana-post-single'); ?>>

	<?php buildana_post_audio(); ?>
    <div class="entry-wrap">
    	<header class="entry-header">
    
    		<?php buildana_maybe_move_title_to_header_title('post'); ?>
    
    		<div class="entry-meta">
    			<?php buildana_post_detail(); ?>
    		</div><!-- .entry-meta -->
    	</header><!-- .entry-header -->
    
    
    	<div class="entry-content">
    		<?php
    		/* translators: %s: Name of current post */
    		the_content( sprintf(
    			__( 'Continue reading %s <span class="meta-nav">&rarr;</span>', 'buildana' ),
    			the_title( '<span class="screen-reader-text">', '</span>', false )
    		) );
    
    		wp_link_pages( array(
    			'before'      => '<div class="page-links"><span class="page-links-title">' . esc_html__( 'Pages:', 'buildana' ) . '</span>',
    			'after'       => '</div>',
    			'link_before' => '<span>',
    			'link_after'  => '</span>',
    		) );
    		?>
    	</div><!-- .entry-content -->
        <?php buildana_entry_footer(); ?>  
    </div>
</article><!-- #post-## -->
