<?php
/**
 * The default template for displaying content
 *
 * Used for both single and index/archive/search.
 *
 * @package WordPress
 * @since 1.0.0
 */
?>
<?php
 
$style ='';
if(has_post_thumbnail()){
    $image = wp_get_attachment_image_src( get_post_thumbnail_id( get_the_ID() ), 'full' );
    $image_url = esc_url($image[0]);
    
}
?>
<article id="post-<?php the_ID(); ?>" <?php post_class('buildana-post-single'); ?>>

    <div class="entry-wrap">
        <div class="entry-inner">
        	<header class="entry-header">
        		<div class="entry-meta">
        			<?php buildana_post_detail(); ?>
        		</div><!-- .entry-meta -->
        	</header><!-- .entry-header -->
        <?php buildana_post_quote(); ?>
        </div>
    </div>
    <div class="entry-content">
    		<?php
    		/* translators: %s: Name of current post */
    		the_content( sprintf(
    			__( 'Continue reading %s <span class="meta-nav">&rarr;</span>', 'buildana' ),
    			the_title( '<span class="screen-reader-text">', '</span>', false )
    		) );
    
    		wp_link_pages( array(
    			'before'      => '<div class="page-links"><span class="page-links-title">' . esc_html__( 'Pages:', 'buildana' ) . '</span>',
    			'after'       => '</div>',
    			'link_before' => '<span>',
    			'link_after'  => '</span>',
    		) );
    		?>
    	</div><!-- .entry-content -->
        <?php buildana_entry_footer(); ?>  
</article><!-- #post-## -->
