<?php
/**
 * The template for displaying Archive pages
 *
 * Used to display archive-type pages if nothing more specific matches a query.
 * For example, puts together date-based pages if no date.php file exists.
 *
 * If you'd like to further customize these archive views, you may create a
 * new template file for each specific one. For example, CMS Theme already
 * has tag.php for Tag archives, category.php for Category archives, and
 * author.php for Author archives.
 *
 * @link http://codex.wordpress.org/Template_Hierarchy
 *
 * @package CMSSuperHeroes
 * @subpackage CMS Theme
 * @since 1.0.0
 */

get_header();
?>
<div id="primary" class="container">
    <main id="main" class="site-main">
        
        <?php
            if( is_front_page() )
                $paged = ( get_query_var('page') ) ? get_query_var('page') : 1;
            else
                $paged = ( get_query_var('paged') ) ? get_query_var('paged') : 1;
                
			$terms = get_term_by('slug', get_query_var('project_category'), get_query_var('taxonomy'));
			$args = array(
				'post_type' => 'project', 
				'posts_per_page' => get_option('posts_per_page'), 
				'orderby' => 'date',
                'paged' => $paged,
				'tax_query' => array(
				    array(
				      'taxonomy' => 'project_category',
				      'field' => 'id',
				      'terms' => $terms->term_id,
				      'include_children' => false
				    )
			  	)
			);
			$project_post = new WP_Query($args);
		?>
        <?php if ( $project_post->have_posts() ) : ?>
            <div class="cms-grid-wraper cms-grid-project template-cms_grid--project ">
                <div class="row cms-grid cms-grid">
                <?php
                $index = 1; 
                while ( $project_post->have_posts() ){
                    $project_post->the_post();
                    if(has_post_thumbnail() && !post_password_required() && !is_attachment() &&  wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()), 'full', false)):
                        $class = ' has-thumbnail';
                        $thumbnail = get_the_post_thumbnail(get_the_ID(),'buildana-540-380');
                    else:
                        $class = ' no-image';
                        $thumbnail = '<img src="'.esc_url(get_template_directory_uri().'/assets/images/no-image.jpg').'" alt="'.get_the_title().'"/>';
                    endif;  
                    ?>
                    <div class="cms-grid-item col-lg-3 col-md-4 col-sm-6 col-xs-12 wow fadeIn" data-wow-delay="<?php echo ''.$index * 50 ?>ms">
                        <article id="post-<?php the_ID(); ?>" <?php post_class('buildana-blog-loop'); ?>>
                            <div class="post-thumbnail">
                                <?php echo buildana_html($thumbnail);?> 
                                <div class="pafter"></div>
                            </div>
                            <div class="entry-wrap">
                            	 
                        		<?php the_title( '<h5 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h5>' ); ?>
                        		<div class="cats">
                        			<?php echo get_the_term_list( get_the_ID(), 'project_category', '', ', ', '' ); ?>
                        		</div> 
                            	 
                            	<div class="entry-content">
                                    <?php echo buildana_project_limit_words(strip_tags(get_the_excerpt()),27);  ?>
                            	</div> 
                                <a class="link-loadmore" href="<?php the_permalink() ?>" title="<?php the_title()?>"><?php echo esc_html__('Reading Continue','buildana');?> <i class="fa fa-chevron-right"></i></a>
                            </div>
                        </article>
                    </div>
                    
                    <?php
                    $index++;
                }
                ?>
                </div>
            </div>
            <?php buildana_paging_nav(); ?>
        <?php else : ?>
			<?php get_template_part( 'single-templates/content', 'none' ); ?>
		<?php endif; ?>
    </main>
</div>
<?php get_footer(); ?>