<?php
/**
 * The template for displaying Archive pages
 *
 * Used to display archive-type pages if nothing more specific matches a query.
 * For example, puts together date-based pages if no date.php file exists.
 *
 * If you'd like to further customize these archive views, you may create a
 * new template file for each specific one. For example, CMS Theme already
 * has tag.php for Tag archives, category.php for Category archives, and
 * author.php for Author archives.
 *
 * @link http://codex.wordpress.org/Template_Hierarchy
 *
 * @package CMSSuperHeroes
 * @subpackage CMS Theme
 * @since 1.0.0
 */

get_header();
?>
<div id="primary" class="container">
    <main id="main" class="site-main">
        
        <?php
            if( is_front_page() )
                $paged = ( get_query_var('page') ) ? get_query_var('page') : 1;
            else
                $paged = ( get_query_var('paged') ) ? get_query_var('paged') : 1;
                
			$terms = get_term_by('slug', get_query_var('services_category'), get_query_var('taxonomy'));
			$args = array(
				'post_type' => 'services', 
				'posts_per_page' => get_option('posts_per_page'), 
				'orderby' => 'date',
                'paged' => $paged,
				'tax_query' => array(
				    array(
				      'taxonomy' => 'services_category',
				      'field' => 'id',
				      'terms' => $terms->term_id,
				      'include_children' => false
				    )
			  	)
			);
			$services_post = new WP_Query($args);
		?>
        <?php if ( $services_post->have_posts() ) : ?>
            <div class="cms-grid-wraper service-style1 template-cms_grid--service_style1 ">
                <div class="row cms-grid cms-grid">
                <?php
                $index = 1; 
                while ( $services_post->have_posts() ){
                    $services_post->the_post();
                    if(has_post_thumbnail() && !post_password_required() && !is_attachment() &&  wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()), 'full', false)):
                        $class = ' has-thumbnail';
                        $thumbnail = get_the_post_thumbnail(get_the_ID(),'medium');
                    else:
                        $class = ' no-image';
                        $thumbnail = '<img src="'.esc_url(get_template_directory_uri().'/assets/images/no-image.jpg').'" alt="'.get_the_title().'"/>';
                    endif;
                    
                    $meta_options = buildana_get_meta_option();
                        $icon_img = !empty($meta_options['service_icon_image']['url']) ? $meta_options['service_icon_image']['url'] : '';
                        $service_icon = !empty($meta_options['service_icon']) ? $meta_options['service_icon'] : '';
                    ?>
                    <div class="cms-grid-item cms-grid-item col-lg-4 col-md-4 col-sm-6 col-xs-12 wow fadeIn" data-wow-delay="<?php echo ''.$index * 50 ?>ms">
                        <article id="post-<?php the_ID(); ?>" <?php post_class('buildana-blog-loop'); ?>>
                            <div class="post-service-thumbnail" onclick="">
                                <?php echo buildana_html($thumbnail);?> 
                                <?php if(!empty($icon_img)){?>
                                    <div class="pafter"><a class="bl-plink" href="<?php the_permalink()?>" title="<?php the_title()?>">
                    				    <img src="<?php echo esc_url($icon_img);?>" />
                                    </a></div>
                                <?php }else{ ?>
                                    <div class="pafter"><a class="bl-plink-font" href="<?php the_permalink()?>" title="<?php the_title()?>">
                                        <i class="<?php echo esc_attr($service_icon);?>"></i>
                                    </a></div>
                                <?php } ?>
                            </div>
                            <div class="entry-wrap text-center">
                            	<header class="entry-header">
                            		<?php the_title( '<h5 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h5>' ); ?>
                            	</header> 
                            	<div class="entry-content">
                                    <?php the_excerpt();  ?>
                            	</div> 
                            </div>
                        </article>
                    </div>
                    
                    <?php
                    $index++;
                }
                ?>
                </div>
            </div>
            <?php buildana_paging_nav(); ?>
        <?php else : ?>
			<?php get_template_part( 'single-templates/content', 'none' ); ?>
		<?php endif; ?>
    </main>
</div>
<?php get_footer(); ?>