<?php 
$word_number = !empty($atts['word_number']) ? $atts['word_number'] : '27';
?>
<div class="cms-carousel owl-carousel <?php echo esc_attr($atts['template']);?>" id="<?php echo esc_attr($atts['html_id']);?>">
    <?php
    $posts = $atts['posts'];
    $index = 1; 
    while($posts->have_posts()){
        $posts->the_post();
        ?>
        <div class="cms-carousel-item">
            <?php 
                if(has_post_thumbnail() && !post_password_required() && !is_attachment() &&  wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()), 'full', false)):
                    $thumbnail = get_the_post_thumbnail(get_the_ID(),'buildana-540-380');
                else:
                    $thumbnail = '<img src="'.esc_url(get_template_directory_uri().'/assets/images/no-image.jpg').'" alt="'.get_the_title().'"/>';
                endif;  
                  
            ?>
            <article id="post-<?php the_ID(); ?>" <?php post_class('buildana-blog-loop'); ?>>
                <div class="post-thumbnail">
                    <?php echo buildana_html($thumbnail);?> 
                    <div class="pafter"></div>
                </div>
                <div class="entry-wrap">
                	 
            		<?php the_title( '<h5 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h5>' ); ?>
            		<div class="cats">
            			<?php echo get_the_term_list( get_the_ID(), 'project_category', '', ', ', '' ); ?>
            		</div> 
                	 
                	<div class="entry-content">
                        <?php echo buildana_project_limit_words(strip_tags(get_the_excerpt()),$word_number);  ?>
                	</div> 
                    <a class="link-loadmore" href="<?php the_permalink() ?>" title="<?php the_title()?>"><?php echo esc_html__('Reading Continue','buildana');?> <i class="fa fa-chevron-right"></i></a>
                </div>
            </article>
        </div>
        <?php
        $index++;
    }
    ?>
</div>
 