<?php
$client = vc_map_get_attributes( $this->getShortcode(), $atts );
extract( $atts );
$values = (array) vc_param_group_parse_atts( $client['values'] );

?>
<div class="cms-client-wrap clients <?php echo esc_attr($class);?>">
    <div class="row cms-client">
    <?php
        $index = 1; 
        foreach($values as $value){
            $image_url = '';
            if (!empty($value['image'])) {
                $attachment_image = wp_get_attachment_image_src($value['image'], 'full');
                $image_url = $attachment_image[0];
            } 
            $link = (isset($value['link'])) ? $value['link'] : '#';
            $link = vc_build_link( $link );
            $use_link = false;
            if ( strlen( $link['url'] ) > 0 ) {
                $use_link = true;
                $a_href = $link['url'];
                $a_title = !empty($link['title'])?$link['title']: '';
                $a_target = strlen( $link['target'] ) > 0 ? $link['target'] : '_self';
            }
            ?> 
            <div class="client-logo text-center <?php echo esc_attr($atts['item_class']);?> wow fadeIn" data-wow-delay="<?php echo ''.$index * 50 ?>ms">
                <div class="client-wrap">
                    <?php if($use_link):?>
                        <a href="<?php echo esc_url($a_href);?>" title="<?php echo esc_attr($a_title);?>" target="<?php echo esc_attr($a_target);?>">
                            <?php if(!empty($image_url)):?>
                            <img src="<?php echo esc_url($image_url);?>" />
                            <?php endif; ?> 
                        </a>
                    <?php else: ?>
                        <?php if(!empty($image_url)):?>
                        <img src="<?php echo esc_url($image_url);?>" />
                        <?php endif; ?> 
                    <?php endif; ?> 
                </div>
            </div>
            
            <?php
            $index++; 
        }
    ?>
    </div>
</div>
