<?php 
    $icon_name = "icon_" . $atts['icon_type'];
    $iconClass = isset($atts[$icon_name])?$atts[$icon_name]:'';
    
    $style='';
    if(!empty($atts['bg_color'])){
        $style= 'style="background-color:'.$atts['bg_color'].';"';
    } 
    if (!empty($atts['image'])) {
        $attachment_image = wp_get_attachment_image_src($atts['image'], 'full');
        $image_url = $attachment_image[0];
    }
?>
<div class="cms-counter-wraper <?php echo esc_attr($atts['template']);?> default" id="<?php echo esc_attr($atts['html_id']);?>">
	 
    <div class="cms-counter-single">
        <?php if( $iconClass ): ?>
			<span class="cms-icon" <?php echo ''.$style;?>><i class="<?php echo esc_attr($iconClass); ?>"></i></span>
		<?php endif; ?>
        <?php if (!empty($atts['image'])) : ?>
            <div class="counter-img" <?php echo ''.$style;?>>
                <img src="<?php echo esc_url($image_url);?>"  class="img-responsive"/>
            </div>
        <?php endif; ?>
        <div class="counter-content">
    		<div id="counter_<?php echo esc_attr($atts['html_id']);?>" class="cms-counter <?php echo esc_attr(strtolower($atts['type']));?>" data-suffix="<?php echo esc_attr($atts['suffix']);?>" data-prefix="<?php echo esc_attr($atts['prefix']);?>" data-type="<?php echo esc_attr(strtolower($atts['type']));?>" data-digit="<?php echo esc_attr($atts['digit']);?>">
    		</div>
            <?php if($atts['c_title']):?>
                <p class="counter-title"><?php echo apply_filters('the_title',$atts['c_title']);?></p>
            <?php endif;?>
        </div>
	</div>
    
</div>