<?php
$fancy_style = ( !empty($atts['fancy_style']) ) ? $atts['fancy_style'] : 'style-0';
$show_border = ( isset($atts['show_border']) && $atts['show_border']) ? 'show-border' : '';
$bottom_overlap = ( isset($atts['bottom_overlap']) && $atts['bottom_overlap']) ? 'bottom-overlap' : '';
?>
<div class="cms-fancyboxes-wraper <?php echo esc_attr($fancy_style);?> <?php echo esc_attr($show_border);?> <?php echo esc_attr($bottom_overlap);?> <?php echo esc_attr($atts['template']);?>" id="<?php echo esc_attr($atts['html_id']);?>">
    <div class="box-inner">
    <div class="row cms-fancyboxes-body">
        <?php
            $columns = ((int)$atts['cms_cols'])?(int)$atts['cms_cols']:1;
            $item_class = "";
            switch($columns){
                    case "1 Column":
                        $item_class = "fancy-item col-xs-12 col-sm-12 col-md-12 col-lg-12";
                        break;
                    case "2 Columns":
                        $item_class = "fancy-item col-xs-12 col-sm-6 col-md-4 col-lg-6";
                        break;
                    case "3 Columns":
                        $item_class = "fancy-item col-xs-12 col-sm-4 col-md-4 col-lg-4";
                        break;
                    case "4 Columns":
                        $item_class = "fancy-item col-xs-12 col-sm-6 col-md-4 col-lg-3";
                        break;
                    case "6 Columns":
                        $item_class = "fancy-item col-xs-12 col-sm-6 col-md-4 col-lg-2";
                        break;

                    default:
                        $item_class = "";
                        break;
                }
            for($i=1;$i<=$columns;$i++){ ?>
                <?php
                $icon = isset($atts['icon'.$i])?$atts['icon'.$i]:'';
                $content = isset($atts['description'.$i])?$atts['description'.$i]:'';
                $image = isset($atts['image'.$i])?$atts['image'.$i]:'';
                $title = isset($atts['title'.$i])?$atts['title'.$i]:'';
                $button_link = isset($atts['button_link'.$i])?$atts['button_link'.$i]:'';
                $image_url = '';
                if (!empty($image)) {
                    $attachment_image = wp_get_attachment_image_src($image, 'full');
                    $image_url = $attachment_image[0];
                }
                ?>
                    <div class="<?php echo esc_attr($item_class);?> text-center" onclick="">
                        <?php if (!empty($image_url)) : ?>
                            <div class="fancy-icon">
                                <img src="<?php echo esc_url($image_url);?>" />
                            </div>
                        <?php elseif(!empty($icon)): ?>
                            <div class="fancy-icon">
                                <i class="<?php echo esc_attr($icon);?>"></i>
                            </div>
                        <?php endif; ?>
                         
                        <?php if($title):?>
                            <h6 class="fancy-title"><?php echo apply_filters('the_title',$title);?></h6>
                        <?php endif;?>
                        <div class="fancy-description">
                            <?php echo apply_filters('the_content',$content);?>
                        </div>
                        
                    </div>
            <?php }
        ?>
    </div>
    </div>
</div>