<?php 
    /* get categories */
    $taxo = 'category';
    $_category = array();
    if(!isset($atts['cat']) || $atts['cat']==''){
        $terms = get_terms($taxo);
        foreach ($terms as $cat){
            $_category[] = $cat->term_id;
        }
    } else {
        $_category  = explode(',', $atts['cat']);
    }
    $atts['categories'] = $_category;
    $word_number = !empty($atts['word_number']) ? $atts['word_number'] : '27';
     
?>
<div class="cms-grid-wraper blog-style2 <?php echo esc_attr($atts['template']);?>" id="<?php echo esc_attr($atts['html_id']);?>">
    <?php if($atts['filter']=="true" && $atts['layout']=='masonry'):?>
        <div class="cms-grid-filter">
            <ul class="cms-filter-category list-unstyled list-inline">
                <li><a class="active" href="#" data-group="all"><?php echo esc_html('All'); ?></a></li>
                <?php 
                if(is_array($atts['categories']))
                foreach($atts['categories'] as $category):?>
                    <?php $term = get_term( $category, $taxo );?>
                    <li><a href="#" data-group="<?php echo esc_attr('category-'.$term->slug);?>">
                            <?php echo esc_html($term->name);?>
                        </a>
                    </li>
                <?php endforeach;?>
            </ul>
        </div>
    <?php endif;?>
    <div class="row cms-grid <?php echo esc_attr($atts['grid_class']);?>">
        <?php
        $posts = $atts['posts'];
        $index = 1; 
        while($posts->have_posts()){
            $posts->the_post();
            $groups = array();
            $groups[] = '"all"';
            foreach(cmsGetCategoriesByPostID(get_the_ID(),$taxo) as $category){
                $groups[] = '"category-'.$category->slug.'"';
            }
            
            $post_format= get_post_format();
            ?>
            <div class="cms-grid-item <?php echo esc_attr($atts['item_class']);?> wow fadeIn" data-wow-delay="<?php echo ''.$index * 50 ?>ms" data-groups='[<?php echo implode(',', $groups);?>]'>
                <article id="post-<?php the_ID(); ?>" <?php post_class('buildana-blog-loop'); ?>>
                    <div class="top-wrap">
                        <?php
                        switch($post_format){
                            case 'audio': ?>   
                            <?php buildana_post_audio(); ?> 
                        <?php break; case 'video': ?>
                            <div class="entry-video">
                                <?php buildana_post_video(); ?>
                            </div>
                        <?php break; case 'gallery': ?>
                            <?php buildana_post_gallery2(); ?>
                        <?php break; case 'quote': ?>
                            <?php buildana_post_quote(); ?>
                        <?php break; default: ?>
                            <?php buildana_post_thumbnail2(); ?>
                        <?php break; } ?>
                        <div class="entry-header">
                            <div class="entry-meta">
                    			<?php buildana_archive_detail(); ?>
                    		</div> 
                        </div> 
                    </div>
                    <div class="entry-wrap">
                		<?php the_title( '<h4 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h4>' ); ?>
                		<div class="entry-meta-author">
                			<?php buildana_archive_author_detail(); ?>
                		</div> 
                    </div>
                </article>
            </div>
            <?php
            $index++;
        }
        ?>
    </div>
    <?php 
        if( !isset($atts['show_patination']) || (isset($atts['show_patination']) && $atts['show_patination']=='1'))
            buildana_paging_nav(); 
    ?>
</div>