<?php 
    /* get categories */
    $taxo = 'project_category';
    $_category = array();
    if(!isset($atts['cat']) || $atts['cat']==''){
        $terms = get_terms($taxo);
        foreach ($terms as $cat){
            $_category[] = $cat->term_id;
        }
    } else {
        $_category  = explode(',', $atts['cat']);
    }
    $atts['categories'] = $_category;
    $word_number = !empty($atts['word_number']) ? $atts['word_number'] : '27';
     
?>
<div class="cms-grid-wraper cms-grid-project <?php echo esc_attr($atts['template']);?>" id="<?php echo esc_attr($atts['html_id']);?>">
     
    <div class="row cms-grid <?php echo esc_attr($atts['grid_class']);?>">
        <?php
        $posts = $atts['posts'];
        $index = 1; 
        while($posts->have_posts()){
            $posts->the_post();
            if(has_post_thumbnail() && !post_password_required() && !is_attachment() &&  wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()), 'full', false)):
                $class = ' has-thumbnail';
                $thumbnail = get_the_post_thumbnail(get_the_ID(),'buildana-540-380');
            else:
                $class = ' no-image';
                $thumbnail = '<img src="'.esc_url(get_template_directory_uri().'/assets/images/no-image.jpg').'" alt="'.get_the_title().'"/>';
            endif;  
             
            ?>
            <div class="cms-grid-item <?php echo esc_attr($atts['item_class']);?> wow fadeIn" data-wow-delay="<?php echo ''.$index * 50 ?>ms">
                <article id="post-<?php the_ID(); ?>" <?php post_class('buildana-blog-loop'); ?>>
                    <div class="post-thumbnail">
                        <?php echo buildana_html($thumbnail);?> 
                        <div class="pafter"></div>
                    </div>
                    <div class="entry-wrap">
                    	 
                		<?php the_title( '<h5 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h5>' ); ?>
                		<div class="cats">
                			<?php echo get_the_term_list( get_the_ID(), $taxo, '', ', ', '' ); ?>
                		</div> 
                    	 
                    	<div class="entry-content">
                            <?php echo buildana_project_limit_words(strip_tags(get_the_excerpt()),$word_number);  ?>
                    	</div> 
                        <a class="link-loadmore" href="<?php the_permalink() ?>" title="<?php the_title()?>"><?php echo esc_html__('Reading Continue','buildana');?> <i class="fa fa-chevron-right"></i></a>
                    </div>
                </article>
            </div>
            <?php
            $index++;
        }
        ?>
    </div>
    <?php 
        if( !isset($atts['show_patination']) || (isset($atts['show_patination']) && $atts['show_patination']=='1'))
            buildana_paging_nav(); 
    ?>
</div>