<?php 
    /* get categories */
    $taxo = 'services_category';
    $_category = array();
    if(!isset($atts['cat']) || $atts['cat']==''){
        $terms = get_terms($taxo);
        foreach ($terms as $cat){
            $_category[] = $cat->term_id;
        }
    } else {
        $_category  = explode(',', $atts['cat']);
    }
    $atts['categories'] = $_category;
    $icon_type = !empty($atts['icon_type']) ? $atts['icon_type'] : 'image_icon' ;
    
?>
<div class="cms-grid-wraper service-style1 <?php echo esc_attr($atts['template']);?>" id="<?php echo esc_attr($atts['html_id']);?>">
    <div class="row cms-grid <?php echo esc_attr($atts['grid_class']);?>">
        <?php
        $posts = $atts['posts'];
        $index = 1; 
        while($posts->have_posts()){
            $posts->the_post();
             
            if(has_post_thumbnail() && !post_password_required() && !is_attachment() &&  wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()), 'full', false)):
                $class = ' has-thumbnail';
                $thumbnail = get_the_post_thumbnail(get_the_ID(),'medium');
            else:
                $class = ' no-image';
                $thumbnail = '<img src="'.esc_url(get_template_directory_uri().'/assets/images/no-image.jpg').'" alt="'.get_the_title().'"/>';
            endif;
            
            $meta_options = buildana_get_meta_option();
                $icon_img = !empty($meta_options['service_icon_image']['url']) ? $meta_options['service_icon_image']['url'] : '';
                $service_icon = !empty($meta_options['service_icon']) ? $meta_options['service_icon'] : '';
            
            ?>
            <div class="cms-grid-item <?php echo esc_attr($atts['item_class']);?> wow fadeIn" data-wow-delay="<?php echo ''.$index * 50 ?>ms">
                <article id="post-<?php the_ID(); ?>" <?php post_class('buildana-blog-loop'); ?>>
                    <div class="post-service-thumbnail" onclick="">
                       <?php echo buildana_html($thumbnail);?> 
                        <?php if($icon_type == 'image_icon'){ ?>
                            <?php if(!empty($icon_img)):?>
                                <div class="pafter"><a class="bl-plink" href="<?php the_permalink()?>" title="<?php the_title()?>">
                				    <img src="<?php echo esc_url($icon_img);?>" />
                                </a></div>
                            <?php endif;?>
                        <?php }else{ ?>
                            <?php if(!empty($icon_img)):?>
                                <div class="pafter"><a class="bl-plink-font" href="<?php the_permalink()?>" title="<?php the_title()?>">
                                    <i class="<?php echo esc_attr($service_icon);?>"></i>
                                </a></div>
                            <?php endif;?>
                        <?php } ?>
                    </div>
                    <div class="entry-wrap text-center">
                    	<header class="entry-header">
                    		<?php the_title( '<h5 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h5>' ); ?>
                    	</header> 
                    	<div class="entry-content">
                            <?php the_excerpt();  ?>
                    	</div> 
                    </div>
                </article>
            </div>
            <?php
            $index++;
        }
        ?>
    </div>
    <?php 
        if( !isset($atts['show_patination']) || (isset($atts['show_patination']) && $atts['show_patination']=='1'))
            buildana_paging_nav(); 
    ?>
</div>