<?php 
    $atts = vc_map_get_attributes( $this->getShortcode(), $atts );
    extract( $atts );
    $classes=array('cms-period');
     
    if(!empty($atts['css'])){
        $classes[]=vc_shortcode_custom_css_class($atts['css']);
    }
    $css_class = preg_replace( '/\s+/', ' ', apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, implode( ' ', array_filter( $classes ) ), $this->settings['base'], $atts ) );
    
    $options=(array) vc_param_group_parse_atts($options );
 
?>
<div class="<?php echo esc_attr($css_class);?> text-center">
    <span class="p-top-icon"></span>
    <?php 
        if(!empty($atts['title'])) 
		    echo '<h3 class="title">'. esc_html($atts['title']).'</h3>';
        if(!empty($atts['subtitle'])) 
            echo '<h4 class="subtitle">'. esc_html($atts['subtitle']).'</h4>';
		if(!empty($content))
            echo wpb_js_remove_wpautop( $content, true );
    ?>
    <?php if(!empty($options)):
        echo '<div class="period-tree">';
        $index = 1;
        foreach($options as $option): 
        $align_cls = 'right';
        if(($index % 2) == 0) $align_cls = 'left'; 
        ?>
        <div class="period-item <?php echo esc_attr($align_cls);?> wow fadeIn" data-wow-delay="<?php echo ''.$index * 50 ?>ms">
            <?php if( !empty($option['item_title'])): ?>
                <span class="before-dot"></span>
                <div class="item_title"><?php echo esc_html($option['item_title']);?></div>
            <?php endif; ?> 
        </div>
        <?php 
        $index++;
        endforeach; 
        echo '</div>';
        endif; 
    ?>
</div>