<?php
$testimonial = vc_map_get_attributes( $this->getShortcode(), $atts );
$values = (array) vc_param_group_parse_atts( $testimonial['values'] );
 
?>
<div class="cms-testimonial-vertical">
    <div class="container">
    <div class="row">
        <div class="col-md-4 col-left">
            <div id="carousel-pager" class="carousel-vertical carousel slide" data-ride="carousel" data-interval="300000">
                <div class="carousel-inner vertical">
                    <?php
                    $k=0;
                    foreach($values as $value){
                        if(isset($value['text']) && !empty($value['text'])){ 
                            $image_url = '';
                            if (!empty($value['author_avatar'])) {  
                                $attachment_image = wp_get_attachment_image_src($value['author_avatar'], 'thumbnail');
                                $image_url = $attachment_image[0];
                            }
                        ?>
                        <div class="testi-item <?php echo ''.$k==0 ? 'active' : '';?> item">
                            <div class="testi-item-wrap" data-target="#carousel-main" data-slide-to="<?php echo esc_attr($k);?>">
                                <?php
                                if(!empty($image_url)){
                                    ?>
                                    <div class="author-avatar">
            							<img src="<?php echo esc_url($image_url);?>" />
            						</div>
                                    <?php
                                }
                                ?>
                                <div class="author-title">
                					<?php if(!empty($value['author_name'])):?>
                						<h5><?php echo esc_html($value['author_name']);?></h5>
                                        <?php 
                                        if(!empty($value['author_position'])):
                                            echo '<p>'.esc_html($value['author_position']).'</p>';    
                                        endif; 
                                        ?>
                                    <?php endif;?>
                                </div>
                            </div>
            			</div>   
                        <?php 
                        }
                        $k++;    
                    }
                    ?>
                </div>
                 
            </div>
        </div>
        <div class="col-md-8">
            <div id="carousel-main" class="carousel-main carousel slide " data-ride="carousel" data-interval="300000">
                <div class="carousel-inner">
                    <?php
                    $j=0;
                    foreach($values as $value){
                        if(isset($value['text']) && !empty($value['text'])){ 
                            $image_url = '';
                            if (!empty($value['author_avatar'])) {  
                                $attachment_image = wp_get_attachment_image_src($value['author_avatar'], 'thumbnail');
                                $image_url = $attachment_image[0];
                            }
                        ?>
                        <div class="testi-item <?php echo ''.$j==0 ? 'active' : '';?> item">
            				<div class="author-wrap">
                                <?php
                                if(!empty($image_url)){
                                    ?>
                                    <div class="author-avatar">
            							<img src="<?php echo esc_url($image_url);?>" />
            						</div>
                                    <?php
                                }
                                ?>
                                <div class="author-content">
                                    <div class="blockquote">
                    					<?php echo esc_html($value['text']);?>
                    				</div>
                					<?php if(!empty($value['author_name'])):?>
                						<h5><?php echo esc_html($value['author_name']);?></h5>
                                        <?php 
                                        if(!empty($value['author_position'])):
                                            echo '<p>'.esc_html($value['author_position']).'</p>';    
                                        endif; 
                                        ?>
                                    <?php endif;?>
                                </div>
            				</div>
            			</div>   
                        <?php 
                        }
                        $j++;    
                    }
                    ?>
                </div>
                 
            </div>
        </div>
    </div>
</div>
</div>
