<?php
/**
 * WooCommerce Template Hooks
 *
 * Action/filter hooks used for WooCommerce functions/templates.
 *
 * @author      Knight
 * @category    Core
 * @package     WooCommerce/Templates
 * @version     3.1.x
 */

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

/* WooCommerce Thumbnail */
    $catalog = array(
        'width'     => '570',   // px
        'height'    => '570',   // px
        'crop'      => 1        // true
    );
    $single = array(
        'width'     => '365',   // px 
        'height'    => '430',   // px
        'crop'      => 1        // true
    );
    $thumbnail = array(
        'width'     => '250',   // px
        'height'    => '250',   // px
        'crop'      => 1        // true
    );
    update_option( 'shop_catalog_image_size', $catalog );       
    update_option( 'shop_single_image_size', $single );         
    update_option( 'shop_thumbnail_image_size', $thumbnail ); 

/* cropt catalog image */
add_filter('woocommerce_get_image_size_thumbnail', function ($size) {
    $size['width'] = 570;
    $size['height'] = 570;
    $size['crop'] = 1;
    return $size;
});

/* cropt single image */
add_filter('woocommerce_get_image_size_single', function ($size) {
    $size['width'] = 365;
    $size['height'] = 430;
    $size['crop'] = 1;
    return $size;
});

/* cropt single gallery image */
add_filter('woocommerce_get_image_size_gallery_thumbnail', function ($size) {
    $size['width'] = 250;
    $size['height'] = 250;
    $size['crop'] = 1;
    return $size;
});

/**
 * Unset image width theme support.
 */
add_action( 'after_setup_theme', 'buildana_modify_wc_theme_support', 10 );
function buildana_modify_wc_theme_support() {
    $theme_support = get_theme_support( 'woocommerce' );
    $theme_support = is_array( $theme_support ) ? $theme_support[0] : array();
 
    unset( $theme_support['single_image_width'], $theme_support['thumbnail_image_width'] );
 
    remove_theme_support( 'woocommerce' );

    add_theme_support( 'woocommerce', $theme_support );

    update_option( 'woocommerce_single_image_width', '365' );
    update_option( 'woocommerce_thumbnail_image_width', '570' );

    update_option( 'woocommerce_thumbnail_cropping', 'custom' );
    update_option( 'woocommerce_thumbnail_cropping_custom_width', '570' );
    update_option( 'woocommerce_thumbnail_cropping_custom_height', '570' );
}
 

remove_action('woocommerce_before_main_content', 'woocommerce_breadcrumb', 20);
remove_action( 'woocommerce_cart_collaterals', 'woocommerce_cross_sell_display' );

add_filter( 'woocommerce_show_page_title' , 'buildana_woo_hide_page_title' );
 
function buildana_woo_hide_page_title() {
	return false;
}

/**
 * Remove all default css style
 * add_filter('woocommerce_enqueue_styles', '__return_empty_array');
 */
add_filter('woocommerce_enqueue_styles', '__return_empty_array');

/* Remove style of plugin WooCommerce Quantity Increment */
add_action('wp_enqueue_scripts', 'wcqi_dequeue_quantity');
function wcqi_dequeue_quantity()
{
    wp_dequeue_style('wcqi-css');
}

/**
 * Shop sidebar
 */
function buildana_shop_sidebar(){
    global $opt_theme_options;

    $_sidebar = 'full';

    if(isset($opt_theme_options['woo_loop_layout']))
        $_sidebar = $opt_theme_options['woo_loop_layout'];
    
    if(isset($_GET['layout']) && trim($_GET['layout']) == 'full' )
        $_sidebar = 'full';
    if(isset($_GET['layout']) && trim($_GET['layout']) == 'left' )
        $_sidebar = 'left';
    if(isset($_GET['layout']) && trim($_GET['layout']) == 'right' )
        $_sidebar = 'right';
    return 'is-sidebar-' . esc_attr($_sidebar);
}

function buildana_loop_columns(){
	global $opt_theme_options;
    if(!isset($opt_theme_options['woo_loop_layout']))
        return '4';
        
    $is_sidebar = buildana_shop_sidebar();

    if(isset($_GET['cols']) && trim($_GET['cols']) == 2 )
            return '2';
        if(isset($_GET['cols']) && trim($_GET['cols']) == 3 )
            return '3';
        if(isset($_GET['cols']) && trim($_GET['cols']) == 4 )
            return '4';
    if($is_sidebar == 'is-sidebar-full'){
        return $opt_theme_options['shop_columns_full'];
    }else{
        return $opt_theme_options['shop_columns'];
    }
}



/**
 * Shop product sidebar
 */
function buildana_shop_single_sidebar(){
    global $opt_theme_options;

    $_sidebar = 'full';

    if(isset($opt_theme_options['woo_single_layout']))
        $_sidebar = $opt_theme_options['woo_single_layout'];
    
    if(isset($_GET['layout']) && trim($_GET['layout']) == 'full' )
        $_sidebar = 'full';
    if(isset($_GET['layout']) && trim($_GET['layout']) == 'left' )
        $_sidebar = 'left';
    if(isset($_GET['layout']) && trim($_GET['layout']) == 'right' )
        $_sidebar = 'right';
    return 'is-sidebar-' . esc_attr($_sidebar);
}

remove_action('woocommerce_before_shop_loop_item', 'woocommerce_template_loop_product_link_open', 10);
remove_action('woocommerce_after_shop_loop_item', 'woocommerce_template_loop_product_link_close', 5);


/** add div wrap loop product
 * add_action('woocommerce_before_shop_loop_item', 'buildana_wc_loop_open', 0);
 * add_action('woocommerce_after_shop_loop_item', 'buildana_wc_loop_close', 99999);
*/
add_action('woocommerce_before_shop_loop_item', 'buildana_wc_loop_open', 0);
if (!function_exists('buildana_wc_loop_open')) {
    function buildana_wc_loop_open()
    {
        echo '<div class="wc-product-wrap clearfix">';
    }
}
add_action('woocommerce_after_shop_loop_item', 'buildana_wc_loop_close', 99999);
if (!function_exists('buildana_wc_loop_close')) {
    function buildana_wc_loop_close()
    {
        echo '</div>';
    }
}

/* add div wrap image */
add_action('woocommerce_before_shop_loop_item_title', 'buildana_wc_loop_image_open', 0);
if (!function_exists('buildana_wc_loop_image_open')) {
    function buildana_wc_loop_image_open()
    {
        echo '<div class="wc-img-wrap"><a href="' . esc_url( get_permalink() ) . '">';
    }
}
if (!function_exists('buildana_wc_loop_image_close')) {
    function buildana_wc_loop_image_close()
    {
        echo '</a></div>';
    }
}
add_action('woocommerce_before_shop_loop_item_title', 'buildana_wc_loop_image_close', 9999);

/* add div wrap product content after image overlay */
add_action('woocommerce_shop_loop_item_title', 'buildana_wc_loop_content_open', 1);
function buildana_wc_loop_content_open(){
    echo '<div class="wc-loop-content-wrap">';
}
add_action('woocommerce_after_shop_loop_item', 'buildana_wc_loop_content_close', 999999);
function buildana_wc_loop_content_close(){
    echo '</div>';
}

/**
 * Change title structure
 * woocommerce_after_shop_loop_item hook.
 *
 * @hooked buildana_woocommerce_template_loop_product_title - 10
 */
remove_action('woocommerce_shop_loop_item_title', 'woocommerce_template_loop_product_title', 10);
add_action('woocommerce_shop_loop_item_title', 'buildana_woocommerce_template_loop_product_title', 10);
if (!function_exists('buildana_woocommerce_template_loop_product_title')) {
    function buildana_woocommerce_template_loop_product_title()
    {
        the_title('<h5 class="wc-loop-title"><a href="' . esc_url( get_permalink() ) . '">', '</a></h5>' );
    }
}

/**
 * Change Add to cart button text 
 * buildana_wc_loop_add_to_cart_text
*/
add_filter( 'woocommerce_product_add_to_cart_text' , 'buildana_wc_loop_add_to_cart_text' );
function buildana_wc_loop_add_to_cart_text() {
    global $product;
    $product_type = $product->get_type();
    $product_id = $product-> get_id();
    switch ( $product_type ) {
        case 'external':
            return '';
        break;
        case 'grouped':
            return '';
        break;
        case 'simple':
            return '';
        break;
        case 'variable':
            return '';
        break;
        default:
            return '';
    }
}
/**
 * remove add to cart default class: button
*/
add_filter('woocommerce_loop_add_to_cart_args','buildana_wc_template_loop_add_to_cart',11,2);
function buildana_wc_template_loop_add_to_cart($defaults = array(),$product) {
    $product_id = $product-> get_id();
    if ( $product ) {
        $extend_class = '';
        $product_type = $product-> get_type();
        switch ( $product_type ) {
            case 'external':
                $extend_class = 'icon-link-1-add';
                break;
            case 'grouped':
                $extend_class = 'icon-shopping-cart-add';
                break;
            case 'simple':
               $extend_class = 'icon-shopping-cart';
                break;
            case 'variable':
                $extend_class = 'icon-shopping-cart-add';
                break;
            default:
                $extend_class = 'icon-link-1';
                break;
        } 

        $args = array(
            'quantity' => 1,
            'class'    => implode( ' ', array_filter( array(
                    'icon',
                    $extend_class ,
                    'product_type_' . $product->get_type(),
                    $product->is_purchasable() && $product->is_in_stock() ? 'add_to_cart_button' : '',
                    $product->supports( 'ajax_add_to_cart' ) ? 'ajax_add_to_cart' : '',
            ) ) ),
        );
        $args =  wp_parse_args($args ,$defaults) ;
    }
    return $args ;
}

/**
 * Change title structure
 * woocommerce_after_shop_loop hook.
 *
 * @hooked buildana_woocommerce_pagination - 10
 */
remove_action('woocommerce_after_shop_loop', 'woocommerce_pagination', 10);
add_action('woocommerce_after_shop_loop', 'buildana_woocommerce_pagination', 10);
if (!function_exists('buildana_woocommerce_pagination')) {
    function buildana_woocommerce_pagination()
    {
        global $wp_query;
        if ( $wp_query->max_num_pages <= 1 ) {
        	return;
        }
        ?>
        <nav class="woocommerce-pagination">
            <div class="pagination">
        	<?php
        		echo paginate_links( apply_filters( 'woocommerce_pagination_args', array(
        			'base'         => esc_url_raw( str_replace( 999999999, '%#%', remove_query_arg( 'add-to-cart', get_pagenum_link( 999999999, false ) ) ) ),
        			'format'       => '',
        			'add_args'     => false,
        			'current'      => max( 1, get_query_var( 'paged' ) ),
        			'total'        => $wp_query->max_num_pages,
        			'prev_text'    => esc_html__('Prev Post','buildana'),
        			'next_text'    => esc_html__('Next Post','buildana'),
        			'type'         => 'list',
        			'end_size'     => 3,
        			'mid_size'     => 3,
        		) ) );
        	?>
            </div>
        </nav>
        <?php
    }
}


/* Single Product */
/* add div wrap image / summary */
add_action('woocommerce_before_single_product_summary', 'buildana_woo_wrap_image_summary_open', 0);
if (!function_exists('buildana_woo_wrap_image_summary_open')) {
    function buildana_woo_wrap_image_summary_open()
    {
        echo '<div class="img-summary-wrap row clearfix">';

    }
}
add_action('woocommerce_after_single_product_summary', 'buildana_woo_wrap_image_summary_close', 0);
if (!function_exists('buildana_woo_wrap_image_summary_close')) {
    function buildana_woo_wrap_image_summary_close()
    {
        echo '</div></div>';
    }
}
add_action('woocommerce_before_single_product_summary', 'buildana_woo_wrap_image_open', 1);
add_action('woocommerce_before_single_product_summary', 'buildana_woo_wrap_image_close', 999999);
if (!function_exists('buildana_woo_wrap_image_open')) {
    function buildana_woo_wrap_image_open()
    {
        echo '<div class="wc-single-img-wrap col-md-5 col-lg-5">';
    }
}
if (!function_exists('buildana_woo_wrap_image_close')) {
    function buildana_woo_wrap_image_close()
    {
        echo '</div><div class="col-md-7 col-lg-7">';
    }
}

/*
* Custom image gallery Style
*/
if (!function_exists('buildana_custom_wc_single_gallery')) {
    function buildana_custom_wc_single_gallery()
    {
        $options = array(
            'rtl'            => is_rtl(),
            'animation'      => 'slide',
            'smoothHeight'   => true,
            'directionNav'   => true,
            'controlNav'     => 'thumbnails',
            'slideshow'      => false,
            'animationSpeed' => 500,
            'animationLoop'  => false, // Breaks photoswipe pagination if true.
        );
        return $options;
    }
}
//add_filter('woocommerce_single_product_carousel_options', 'buildana_custom_wc_single_gallery');
 
/* Change title structure */
if (!function_exists('woocommerce_template_single_title')) {
    /**
     * Output the product title.
     *
     * @subpackage  Product
     */
    function woocommerce_template_single_title(){
        global $opt_theme_options;
        if (isset($opt_theme_options['single_shop_set_title_is_page_title']) && $opt_theme_options['single_shop_set_title_is_page_title'] == '1') return;
        the_title('<h3 class="product-title">', '</h3>');  
    }
}

/**
 * Change title structure
 * woocommerce_single_product_summary hook.
 *
 * @hooked woocommerce_template_single_rating - 10
 */
remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_rating', 10);
add_action('woocommerce_single_product_summary', 'buildana_woocommerce_template_single_rating', 5);
if (!function_exists('buildana_woocommerce_template_single_rating')) {
    function buildana_woocommerce_template_single_rating()
    {
        global $product;
        if ( 'no' === get_option( 'woocommerce_enable_review_rating' ) ) {
        	return;
        }
        
        $rating_count = $product->get_rating_count();
        $review_count = $product->get_review_count();
        $average      = $product->get_average_rating();
        
        if ( $rating_count > 0 ) : ?>
        
        	<div class="woocommerce-product-rating">
        		<?php echo wc_get_rating_html( $average, $rating_count ); ?>
        		<?php if ( comments_open() ) : ?><a href="#reviews" class="woocommerce-review-link" rel="nofollow">(<?php printf( _n( '%s Review', '%s Reviews', $review_count, 'buildana' ), '<span class="count">' . esc_html( $review_count ) . '</span>' ); ?>)</a><?php endif ?>
        	</div>
        
        <?php endif; ?>
        <?php
    }
}

/**
 * Add theme share
 * add_action('woocommerce_product_meta_end', 'buildana_product_sharing', 0);
 */
add_action('woocommerce_share','buildana_product_sharing');
 

add_action('woocommerce_product_additional_information', 'buildana_add_post_nav', 99999);
if (!function_exists('buildana_add_post_nav')) {
    function buildana_add_post_nav()
    {
        buildana_product_nav();
    }
}


add_action('woocommerce_review_before_comment_meta', 'buildana_review_before_comment_meta_open', 0);
if (!function_exists('buildana_review_before_comment_meta_open')) {
    function buildana_review_before_comment_meta_open()
    {
        echo '<div class="comment-meta-wrap">';
    }
}

add_action('woocommerce_review_meta', 'buildana_woocommerce_review_meta_close', 999);
if (!function_exists('buildana_woocommerce_review_meta_close')) {
    function buildana_woocommerce_review_meta_close()
    {
        echo '</div>';
    }
}

/* Move process checkout button */
remove_action('woocommerce_proceed_to_checkout', 'woocommerce_button_proceed_to_checkout', 20);
add_action('woocommerce_cart_actions', 'woocommerce_button_proceed_to_checkout', 20);
 
 
add_action('woocommerce_checkout_before_customer_details', 'buildana_woocommerce_checkout_before_customer_details', 0);
if (!function_exists('buildana_woocommerce_checkout_before_customer_details')) {
    function buildana_woocommerce_checkout_before_customer_details()
    {
        echo '<div class="row"><div class="col-sx-12 col-sm-12 col-md-6">';
    }
}

add_action('woocommerce_checkout_after_customer_details', 'buildana_woocommerce_checkout_after_customer_details', 999);
if (!function_exists('buildana_woocommerce_checkout_after_customer_details')) {
    function buildana_woocommerce_checkout_after_customer_details()
    {
        echo '</div>';
    }
}
add_action('woocommerce_checkout_before_order_review', 'buildana_woocommerce_checkout_before_order_review', 999);
if (!function_exists('buildana_woocommerce_checkout_before_order_review')) {
    function buildana_woocommerce_checkout_before_order_review()
    {
        echo '<div class="col-sx-12 col-sm-12 col-md-6">';
    }
}

add_action('woocommerce_checkout_after_order_review', 'buildana_woocommerce_checkout_after_order_review', 0);
if (!function_exists('buildana_woocommerce_checkout_after_order_review')) {
    function buildana_woocommerce_checkout_after_order_review()
    {
        echo '</div></div>';
    }
}

/**
 * Remove field label
 * add_filter( 'woocommerce_form_field_args' , 'buildana_override_woocommerce_form_field' );
 */
add_filter( 'woocommerce_form_field_args' , 'buildana_override_woocommerce_form_field' );
function buildana_override_woocommerce_form_field($args)
{
    $args['label'] = false;
    return $args;
}

/* Overide checkout field */
function buildana_override_checkout_fields( $fields ) {
    $fields['billing']['billing_first_name']['placeholder'] = esc_html__('First Name *','buildana');
    $fields['billing']['billing_last_name']['placeholder'] = esc_html__('Last Name *','buildana');
    $fields['billing']['billing_company']['placeholder'] = esc_html__('Company Name','buildana');
    $fields['billing']['billing_email']['placeholder'] = esc_html__('Email Address *','buildana');
    $fields['billing']['billing_phone']['placeholder'] = esc_html__('Phone *','buildana');
    $fields['billing']['billing_city']['placeholder'] = esc_html__('Town / City *','buildana');
    $fields['billing']['billing_postcode']['placeholder'] = esc_html__('Postcode *','buildana');
    $fields['billing']['billing_state']['placeholder'] = esc_html__('State *','buildana');
    $fields['billing']['billing_country']['placeholder'] = esc_html__('Country *','buildana');

    $fields['shipping']['shipping_first_name']['placeholder'] = esc_html__('First Name *','buildana');
    $fields['shipping']['shipping_last_name']['placeholder'] = esc_html__('Last Name *','buildana');
    $fields['shipping']['shipping_company']['placeholder'] = esc_html__('Company Name','buildana');
    $fields['shipping']['shipping_city']['placeholder'] = esc_html__('Town / City *','buildana');
    $fields['shipping']['shipping_postcode']['placeholder'] = esc_html__('Postcode *','buildana');
    $fields['shipping']['shipping_state']['placeholder'] = esc_html__('State *','buildana');
    $fields['shipping']['shipping_country']['placeholder'] = esc_html__('Country *','buildana');
    
    $fields['account']['account_username']['placeholder'] = esc_html__('Username or email *','buildana');
    $fields['account']['account_password']['placeholder'] = esc_html__('Password *','buildana');
    $fields['account']['account_password-2']['placeholder'] = esc_html__('Retype Password *','buildana');

    $fields['order']['order_comments']['placeholder'] = esc_html__('Order Notes','buildana');

    /* Add Email/ Phone on Shipping fields*/
    $fields['shipping']['shipping_email'] = array(
		'label'     	=> esc_html__('Email Address', 'buildana'),
		'placeholder'   => _x('Email Address', 'placeholder', 'buildana'),
		'required'  	=> false,
		'class'     	=> array('form-row-first'),
		'clear'     	=> false
	);
    $fields['shipping']['shipping_phone'] = array(
		'label'     	=> esc_html__('Phone', 'buildana'),
		'placeholder'   => _x('Phone', 'placeholder', 'buildana'),
		'required'  	=> false,
		'class'     	=> array('form-row-last'),
		'clear'     	=> true,
		'order'			=> '6'
	);

    return $fields;
}
add_filter( 'woocommerce_checkout_fields' , 'buildana_override_checkout_fields' );


